/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.beans.ConstructorProperties;

public class ConfigHandler {
    private String name;
    private String sys;
    private String env;
    private String defaultValue;
    private Object initialValue;
    private Class<?> type;
    @JsonIgnore
    private Runnable updater;
    @JsonIgnore
    private Runnable resetter;

    @Inject
    public void init(Injector injector) {
        injector.injectMembers((Object)this.updater);
        injector.injectMembers((Object)this.resetter);
    }

    public static ConfigHandlerBuilder builder() {
        return new ConfigHandlerBuilder();
    }

    @ConstructorProperties(value={"name", "sys", "env", "defaultValue", "initialValue", "type", "updater", "resetter"})
    public ConfigHandler(String name, String sys, String env, String defaultValue, Object initialValue, Class<?> type, Runnable updater, Runnable resetter) {
        this.name = name;
        this.sys = sys;
        this.env = env;
        this.defaultValue = defaultValue;
        this.initialValue = initialValue;
        this.type = type;
        this.updater = updater;
        this.resetter = resetter;
    }

    public ConfigHandler() {
    }

    public String getName() {
        return this.name;
    }

    public String getSys() {
        return this.sys;
    }

    public String getEnv() {
        return this.env;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Runnable getUpdater() {
        return this.updater;
    }

    public Runnable getResetter() {
        return this.resetter;
    }

    public static class ConfigHandlerBuilder {
        private String name;
        private String sys;
        private String env;
        private String defaultValue;
        private Object initialValue;
        private Class<?> type;
        private Runnable updater;
        private Runnable resetter;

        ConfigHandlerBuilder() {
        }

        public ConfigHandlerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConfigHandlerBuilder sys(String sys) {
            this.sys = sys;
            return this;
        }

        public ConfigHandlerBuilder env(String env) {
            this.env = env;
            return this;
        }

        public ConfigHandlerBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ConfigHandlerBuilder initialValue(Object initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public ConfigHandlerBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public ConfigHandlerBuilder updater(Runnable updater) {
            this.updater = updater;
            return this;
        }

        public ConfigHandlerBuilder resetter(Runnable resetter) {
            this.resetter = resetter;
            return this;
        }

        public ConfigHandler build() {
            return new ConfigHandler(this.name, this.sys, this.env, this.defaultValue, this.initialValue, this.type, this.updater, this.resetter);
        }

        public String toString() {
            return "ConfigHandler.ConfigHandlerBuilder(name=" + this.name + ", sys=" + this.sys + ", env=" + this.env + ", defaultValue=" + this.defaultValue + ", initialValue=" + this.initialValue + ", type=" + this.type + ", updater=" + this.updater + ", resetter=" + this.resetter + ")";
        }
    }
}

