/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.impl;

import com.google.inject.Injector;
import io.partx.core.Config;
import io.partx.core.Context;
import io.partx.core.Event;
import io.partx.core.Metadata;
import io.partx.core.Workers;
import io.partx.core.impl.ModuleContext;
import io.vertx.config.ConfigChange;
import io.vertx.core.Handler;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextImpl
implements Context {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private final Config config;
    private ModuleContext module;
    private Metadata metadata;

    public ContextImpl(Metadata metadata, Config config) {
        this.metadata = metadata;
        this.config = config;
    }

    public void init(ModuleContext moduleContext) {
        this.config().listen((Handler<ConfigChange>)((Handler)change -> {
            log.debug("Config changed: {} {} -> {}", new Object[]{Objects.equals(change.getPreviousConfiguration(), change.getNewConfiguration()), change.getPreviousConfiguration(), change.getNewConfiguration()});
            moduleContext.getConfigHandlers().forEach(handler -> handler.getUpdater().run());
        }));
        moduleContext.getMetricHandlers().forEach(metricHandler -> metricHandler.register(moduleContext.getInjector()));
        this.module = moduleContext;
        this.notify(Event.Initialize);
    }

    public Injector injector() {
        return this.module.getInjector();
    }

    public Config config() {
        return this.config;
    }

    @Override
    public void notify(Event event) {
        this.module.notify(event);
    }

    @Override
    public void start() {
        Thread shutdownHook = new Thread(() -> this.run(() -> {
            this.stop();
            return null;
        }));
        shutdownHook.setName("App-" + this.metadata.getName() + "-ShutdownHook");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.run(() -> {
            this.notify(Event.Start);
            log.info("Context started in {} ms", (Object)this.metadata.getLiveTimeMs());
            return null;
        });
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.module.getInstance(type);
    }

    @Override
    public <T> CompletableFuture<T> run(Callable<T> runnable, boolean blocking) {
        return ((Workers)this.injector().getInstance(Workers.class)).execute(runnable, blocking);
    }

    public ModuleContext getModule() {
        return this.module;
    }
}

