/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.impl;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;

public class MetricHandler {
    private String name;
    private Supplier<? extends Metric> getter;
    private Object origin;

    public void register(Injector injector) {
        Preconditions.checkNotNull((Object)this.name);
        injector.injectMembers(this.getter);
        Metric metric = this.getter.get();
        Preconditions.checkNotNull((Object)metric, (Object)(this.name + " on " + this.origin + " is not initialized"));
        ((MetricRegistry)injector.getInstance(MetricRegistry.class)).register(this.name, metric);
    }

    public static MetricHandlerBuilder builder() {
        return new MetricHandlerBuilder();
    }

    public MetricHandler() {
    }

    @ConstructorProperties(value={"name", "getter", "origin"})
    public MetricHandler(String name, Supplier<? extends Metric> getter, Object origin) {
        this.name = name;
        this.getter = getter;
        this.origin = origin;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<? extends Metric> getGetter() {
        return this.getter;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public static class MetricHandlerBuilder {
        private String name;
        private Supplier<? extends Metric> getter;
        private Object origin;

        MetricHandlerBuilder() {
        }

        public MetricHandlerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricHandlerBuilder getter(Supplier<? extends Metric> getter) {
            this.getter = getter;
            return this;
        }

        public MetricHandlerBuilder origin(Object origin) {
            this.origin = origin;
            return this;
        }

        public MetricHandler build() {
            return new MetricHandler(this.name, this.getter, this.origin);
        }

        public String toString() {
            return "MetricHandler.MetricHandlerBuilder(name=" + this.name + ", getter=" + this.getter + ", origin=" + this.origin + ")";
        }
    }
}

