/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.partx.core.Event;
import io.partx.core.ModuleRegistry;
import io.partx.core.impl.ConfigHandler;
import io.partx.core.impl.EventHandler;
import io.partx.core.impl.KernalModule;
import io.partx.core.impl.MetricHandler;
import io.partx.core.vertx.RouteModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleContext
implements ModuleRegistry {
    private static final Logger log = LoggerFactory.getLogger(ModuleContext.class);
    private final Injector injector;
    private final ModuleRegistry registry = ModuleRegistry.create();
    private final Map<Class<?>, Object> instances = new HashMap();

    public ModuleContext(List<Module> rootModules, List<Module> externModules, List<Class<?>> configuredClass, List<Object> pojoList) {
        Injector rootInjector = Guice.createInjector((Iterable)ImmutableList.builder().addAll(rootModules).add((Object)new KernalModule(this.registry)).add((Object)new RouteModule(this.registry)).build());
        externModules.forEach(arg_0 -> ((Injector)rootInjector).injectMembers(arg_0));
        this.injector = rootInjector.createChildInjector(externModules);
        pojoList.forEach(arg_0 -> ((Injector)this.injector).injectMembers(arg_0));
        configuredClass.forEach(clazz -> this.instances.put((Class<?>)clazz, this.injector.getInstance(clazz)));
        ImmutableList.copyOf((Collection)this.registry.getAll().entries()).forEach(entry -> this.injector.injectMembers(entry.getValue()));
        log.info("Loaded {} facets", (Object)this.registry.getAll().size());
    }

    public <T> T getInstance(Class<T> type) {
        Object obj = this.instances.get(type);
        if (obj == null) {
            return (T)this.injector.getInstance(type);
        }
        return (T)obj;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> void register(Class<T> type, T instance) {
        this.registry.register(type, instance);
    }

    @Override
    public <T> List<T> get(Class<T> type) {
        return this.registry.get(type);
    }

    @Override
    public Multimap<Class<?>, Object> getAll() {
        return this.registry.getAll();
    }

    public List<EventHandler> getEventHandlers() {
        return this.get(EventHandler.class);
    }

    public List<MetricHandler> getMetricHandlers() {
        return this.get(MetricHandler.class);
    }

    public List<ConfigHandler> getConfigHandlers() {
        return this.get(ConfigHandler.class);
    }

    public void notify(Event event) {
        Preconditions.checkArgument((!event.isExpired() ? 1 : 0) != 0, (Object)("Event already expired: " + event));
        int errorCount = 0;
        int notifiedCount = 0;
        List sortedListeners = Ordering.from(event.isReversed() ? Comparator.comparingInt(EventHandler::getOrder).reversed() : Comparator.comparingInt(EventHandler::getOrder)).sortedCopy(this.getEventHandlers());
        block4: for (EventHandler listener : sortedListeners) {
            if (event.getAddress() != null && event.getAddress() != listener.getInstance() || !listener.getType().isEmpty() && !listener.getType().contains((Object)event.getType())) continue;
            if (listener.getExpect().isEmpty()) {
                ++notifiedCount;
                try {
                    listener.getListener().onEvent(event);
                }
                catch (Throwable throwable) {
                    log.error("Failed to notify {}: {}", new Object[]{listener, event, throwable});
                    if (event.getDelivery() == Event.Delivery.FailFast) {
                        throw new IllegalStateException(throwable);
                    }
                    ++errorCount;
                }
                continue;
            }
            for (Class<?> expect : listener.getExpect()) {
                if (event.getCause() == null || !expect.isAssignableFrom(event.getCause().getClass())) continue;
                try {
                    ++notifiedCount;
                    listener.getListener().onEvent(event);
                }
                catch (Throwable throwable) {
                    if (event.getDelivery() == Event.Delivery.FailFast) {
                        throw new IllegalStateException(throwable);
                    }
                    log.error("Failed to notify {}: {}", new Object[]{listener, event, throwable});
                    ++errorCount;
                }
                continue block4;
            }
        }
        if (errorCount > 0) {
            throw new IllegalArgumentException("Got " + errorCount + " exceptions to notify event for " + notifiedCount + " times: " + event);
        }
        if (notifiedCount == 0) {
            log.warn("Event not handled: " + event);
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    public ModuleRegistry getRegistry() {
        return this.registry;
    }

    public static class Builder {
        private List<Module> appModules = new ArrayList<Module>();
        private List<Module> rootModules = new ArrayList<Module>();
        private List<Class<?>> classList = new ArrayList();
        private List<Object> instanceList = new ArrayList<Object>();

        public Builder modules(List<Module> modules) {
            this.appModules.addAll(modules);
            return this;
        }

        public Builder root(List<Module> modules) {
            this.rootModules.addAll(modules);
            return this;
        }

        public Builder classes(List<Class<?>> classes) {
            this.classList.addAll(classes);
            return this;
        }

        public Builder objects(List<Object> instances) {
            this.instanceList.addAll(instances);
            return this;
        }

        public ModuleContext build() {
            return new ModuleContext(this.rootModules, this.appModules, this.classList, this.instanceList);
        }
    }
}

