/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.impl;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(RouteHandler.class);
    private String path;
    private boolean regexp;
    private Set<HttpMethod> method;
    private Set<String> produces;
    private Set<String> consumes;
    private boolean blocking;
    private boolean ordered;
    private Handler<RoutingContext> handler;
    private int order;
    private Object origin;
    private static Set<HttpMethod> HTTP_METHOD_ALL = Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.TRACE, HttpMethod.CONNECT, HttpMethod.PATCH, HttpMethod.OTHER});

    @Inject
    public void init(Injector injector) {
        injector.injectMembers(this.handler);
    }

    public void register(Router router) {
        if (this.method == null) {
            log.debug("[*] {} --> {}", (Object)(StringUtils.isBlank((CharSequence)this.path) ? "*" : this.path), this.origin != null ? this.origin : this.handler);
        } else {
            log.debug("{} {} --> {}", new Object[]{HTTP_METHOD_ALL.equals(this.method) ? "[*]" : this.method, StringUtils.isBlank((CharSequence)this.path) ? "*" : this.path, this.origin != null ? this.origin : this.handler});
        }
        Route route = StringUtils.isBlank((CharSequence)this.path) ? router.route() : (this.isRegexp() ? router.routeWithRegex(this.path) : router.route(this.path));
        if (this.method != null && !this.method.isEmpty() && !HTTP_METHOD_ALL.equals(this.method)) {
            this.method.forEach(arg_0 -> ((Route)route).method(arg_0));
        }
        if (this.produces != null) {
            this.produces.stream().filter(StringUtils::isNotBlank).forEach(arg_0 -> ((Route)route).produces(arg_0));
        }
        if (this.consumes != null) {
            this.consumes.stream().filter(StringUtils::isNotBlank).forEach(arg_0 -> ((Route)route).consumes(arg_0));
        }
        if (this.blocking) {
            route.blockingHandler(this.handler, this.ordered);
        } else {
            route.handler(this.handler);
        }
    }

    public static RouteHandlerBuilder builder() {
        return new RouteHandlerBuilder();
    }

    @ConstructorProperties(value={"path", "regexp", "method", "produces", "consumes", "blocking", "ordered", "handler", "order", "origin"})
    public RouteHandler(String path, boolean regexp, Set<HttpMethod> method, Set<String> produces, Set<String> consumes, boolean blocking, boolean ordered, Handler<RoutingContext> handler, int order, Object origin) {
        this.path = path;
        this.regexp = regexp;
        this.method = method;
        this.produces = produces;
        this.consumes = consumes;
        this.blocking = blocking;
        this.ordered = ordered;
        this.handler = handler;
        this.order = order;
        this.origin = origin;
    }

    public RouteHandler() {
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public void setRegexp(boolean regexp) {
        this.regexp = regexp;
    }

    public Set<HttpMethod> getMethod() {
        return this.method;
    }

    public void setMethod(Set<HttpMethod> method) {
        this.method = method;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public void setHandler(Handler<RoutingContext> handler) {
        this.handler = handler;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public void setOrigin(Object origin) {
        this.origin = origin;
    }

    public static class RouteHandlerBuilder {
        private String path;
        private boolean regexp;
        private Set<HttpMethod> method;
        private Set<String> produces;
        private Set<String> consumes;
        private boolean blocking;
        private boolean ordered;
        private Handler<RoutingContext> handler;
        private int order;
        private Object origin;

        RouteHandlerBuilder() {
        }

        public RouteHandlerBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RouteHandlerBuilder regexp(boolean regexp) {
            this.regexp = regexp;
            return this;
        }

        public RouteHandlerBuilder method(Set<HttpMethod> method) {
            this.method = method;
            return this;
        }

        public RouteHandlerBuilder produces(Set<String> produces) {
            this.produces = produces;
            return this;
        }

        public RouteHandlerBuilder consumes(Set<String> consumes) {
            this.consumes = consumes;
            return this;
        }

        public RouteHandlerBuilder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public RouteHandlerBuilder ordered(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public RouteHandlerBuilder handler(Handler<RoutingContext> handler) {
            this.handler = handler;
            return this;
        }

        public RouteHandlerBuilder order(int order) {
            this.order = order;
            return this;
        }

        public RouteHandlerBuilder origin(Object origin) {
            this.origin = origin;
            return this;
        }

        public RouteHandler build() {
            return new RouteHandler(this.path, this.regexp, this.method, this.produces, this.consumes, this.blocking, this.ordered, this.handler, this.order, this.origin);
        }

        public String toString() {
            return "RouteHandler.RouteHandlerBuilder(path=" + this.path + ", regexp=" + this.regexp + ", method=" + this.method + ", produces=" + this.produces + ", consumes=" + this.consumes + ", blocking=" + this.blocking + ", ordered=" + this.ordered + ", handler=" + this.handler + ", order=" + this.order + ", origin=" + this.origin + ")";
        }
    }
}

