/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.utils;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public interface Async {
    public static void await(Supplier<Boolean> condition) {
        Async.await(condition, 10L, 1L, TimeUnit.MINUTES);
    }

    public static void await(Supplier<Boolean> condition, long checkMs, long timeout, TimeUnit timeUnit) {
        try {
            CompletableFuture.runAsync(() -> {
                while (!((Boolean)condition.get()).booleanValue()) {
                    try {
                        Thread.sleep(checkMs);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }).get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> AsyncResult<T> await(AsyncHandler<T> resultHandler) {
        CompletableFuture completableFuture = new CompletableFuture();
        resultHandler.get(completableFuture::complete);
        try {
            return (AsyncResult)completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> AsyncResult<T> await(Future<T> future) {
        CompletableFuture completableFuture = new CompletableFuture();
        future.setHandler(completableFuture::complete);
        try {
            return (AsyncResult)completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @FunctionalInterface
    public static interface AsyncHandler<T> {
        public void get(Handler<AsyncResult<T>> var1);
    }
}

