/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonModifier {
    private Pattern propertyKeyPattern = Pattern.compile("'([^\"]*)'");
    private final JsonObject jsonObject;

    public JsonModifier(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JsonObject json() {
        return this.jsonObject;
    }

    public JsonObject set(String path, Object value) {
        this.checkPath(path);
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JsonObject json = this.jsonObject;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                json.put(token, value);
                break;
            }
            if (json.containsKey(token)) {
                try {
                    json = json.getJsonObject(token);
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException(path + " at " + token + " is not object but: " + json.getValue(token));
                }
            }
            json = json.put(token, new JsonObject());
        }
        return this.jsonObject;
    }

    public JsonObject patch(String path, JsonObject value) {
        this.checkPath(path);
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JsonObject parent = this.jsonObject;
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (!parent.containsKey(token)) {
                parent.put(token, new JsonObject());
            }
            parent = parent.getJsonObject(token);
            if (tokens.hasMoreTokens()) continue;
            parent.mergeIn(value);
            break;
        }
        return this.jsonObject;
    }

    public JsonObject put(String path, Object value) {
        this.checkPath(path);
        return this.jsonObject.put(path, value);
    }

    public <T> Optional<T> resolve(String path, Class<T> type) {
        return this.resolve(path).map(o -> {
            if (type.isAssignableFrom(o.getClass())) {
                return o;
            }
            return Json.decodeValue((Buffer)Json.encodeToBuffer((Object)o), (Class)type);
        });
    }

    public <T> Optional<T> resolve(String path, TypeReference<T> type) {
        return this.resolve(path).map(o -> Json.decodeValue((Buffer)Json.encodeToBuffer((Object)o), (TypeReference)type));
    }

    public Optional<Object> resolve(String path) {
        Matcher matcher = this.propertyKeyPattern.matcher(path);
        if (matcher.find()) {
            return Optional.ofNullable(this.jsonObject.getValue(matcher.group(1)));
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        JsonObject json = this.jsonObject;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return Optional.ofNullable(json.getValue(token));
            }
            if (!json.containsKey(token)) {
                json.put(token, new JsonObject());
            }
            json = json.getJsonObject(token);
        }
        return Optional.empty();
    }

    private void checkPath(String path) {
        Preconditions.checkArgument((!this.propertyKeyPattern.matcher(path).find() ? 1 : 0) != 0, (Object)"Invalid config path");
    }

    public JsonObject patch(JsonObject jsonObject) {
        return this.jsonObject.mergeIn(jsonObject, true);
    }
}

