/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Yaml {
    private static final YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
    private static ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
    private static ObjectMapper prettyMapper = new ObjectMapper((JsonFactory)yamlFactory);

    public static ObjectMapper mapper() {
        return mapper;
    }

    public static ObjectMapper prettyMapper() {
        return prettyMapper;
    }

    public static String encode(Object obj) throws EncodeException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static Buffer encodeToBuffer(Object obj) throws EncodeException {
        try {
            return Buffer.buffer((byte[])mapper.writeValueAsBytes(obj));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        try {
            return prettyMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        try {
            return (T)mapper.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        try {
            return (T)mapper.readValue(str, type);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        try {
            return (T)mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), type);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        try {
            return (T)mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    static Object checkAndCopy(Object val, boolean copy) {
        if (!(val == null || val instanceof Number && !(val instanceof BigDecimal) || val instanceof Boolean || val instanceof String || val instanceof Character)) {
            if (val instanceof CharSequence) {
                val = val.toString();
            } else if (val instanceof JsonObject) {
                if (copy) {
                    val = ((JsonObject)val).copy();
                }
            } else if (val instanceof JsonArray) {
                if (copy) {
                    val = ((JsonArray)val).copy();
                }
            } else if (val instanceof Map) {
                val = copy ? new JsonObject((Map)val).copy() : new JsonObject((Map)val);
            } else if (val instanceof List) {
                val = copy ? new JsonArray((List)val).copy() : new JsonArray((List)val);
            } else if (val instanceof byte[]) {
                val = Base64.getEncoder().encodeToString((byte[])val);
            } else if (val instanceof Instant) {
                val = DateTimeFormatter.ISO_INSTANT.format((Instant)val);
            } else {
                throw new IllegalStateException("Illegal type in JsonObject: " + val.getClass());
            }
        }
        return val;
    }

    static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        prettyMapper.setTimeZone(TimeZone.getDefault());
        prettyMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        prettyMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, (JsonSerializer)new JsonArraySerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        mapper.registerModule((Module)module);
        prettyMapper.registerModule((Module)module);
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private final Base64.Encoder BASE64 = Base64.getEncoder();

        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(this.BASE64.encodeToString(value));
        }
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(DateTimeFormatter.ISO_INSTANT.format(value));
        }
    }

    private static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        private JsonArraySerializer() {
        }

        public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.getList());
        }
    }

    private static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        private JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.getMap());
        }
    }
}

