/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.partx.core.Context;
import io.partx.core.Event;
import io.partx.core.Metadata;
import io.partx.core.annotation.Config;
import io.partx.core.annotation.Listen;
import io.partx.core.annotation.Metric;
import io.partx.core.annotation.Route;
import io.partx.core.impl.ContextImpl;
import io.partx.core.impl.ModuleContext;
import io.partx.core.impl.RouteHandler;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.vertx.MetricsHandler;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.ErrorHandler;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpService
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    @Inject
    private HttpServer httpServer;
    @Inject
    private Context context;
    @Config(value="http.server.port", env="HTTP_PORT", defaultValue="8080")
    private int httpPort;
    @Config(value="http.server.ip", env="HTTP_IP", defaultValue="localhost")
    private String httpIp;
    @Config(value="http.server.ssl", env="HTTPS_ENABLED", defaultValue="true")
    private boolean ssl;
    @Metric(value="http_server_up")
    private final AtomicBoolean up = new AtomicBoolean(false);
    @Metric(value="http_error_count")
    private final Counter errorCount = new Counter();
    @Inject
    private Vertx vertx;
    @Inject
    private ErrorHandler errorHandler;
    @Inject
    private MetricRegistry metricRegistry;

    private Router router(Context context) {
        ModuleContext facetsContext = ((ContextImpl)context).getModule();
        Router router = Router.router((Vertx)((Vertx)facetsContext.getInjector().getInstance(Vertx.class)));
        Ordering.from(Comparator.comparingInt(RouteHandler::getOrder)).sortedCopy(facetsContext.getRegistry().get(RouteHandler.class)).forEach(routeHandler -> routeHandler.register(router));
        router.route().handler((Handler)this.errorHandler);
        router.exceptionHandler(this::routeException);
        log.info("Registered {} http routes", (Object)router.getRoutes().size());
        return router;
    }

    @Route(path="/api/v1/partx/modules")
    public ModuleContext getFacets() {
        return ((ContextImpl)this.context).getModule();
    }

    @Route(path="/api/v1/partx/version")
    public Metadata getVersion() {
        return this.context.metadata();
    }

    @Route(path="/metrics", method={HttpMethod.GET})
    public MetricsHandler getMetrics() {
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.metricRegistry));
        return new MetricsHandler();
    }

    @Listen(value={Event.Type.Start}, order=0x7FFFFFFF)
    public void deploy() {
        this.vertx.deployVerticle((Verticle)this, event -> {
            if (event.succeeded()) {
                log.info("Deployed HttpService {} in {} ms", event.result(), (Object)this.context.metadata().getLiveTimeMs());
            } else {
                log.error("Failed to deploy HttpService", event.cause());
                this.context.fail(event.cause());
            }
        });
    }

    public void start(Future<Void> future) {
        Router router = this.router(this.context);
        log.info("HttpServer listening on {}:{}", (Object)this.httpIp, (Object)this.httpPort);
        this.httpServer.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).exceptionHandler(arg_0 -> future.fail(arg_0)).listen(this.httpPort, this.httpIp, event -> {
            if (event.failed()) {
                this.up.set(false);
                log.error("HttpServer failed to listen on {}:{}", new Object[]{this.httpIp, this.httpPort, event.cause()});
                future.fail(event.cause());
            } else {
                this.up.set(true);
                log.info("HttpServer is up on {}:{}", (Object)this.httpIp, (Object)this.httpPort);
                future.complete();
            }
        });
    }

    @Listen(value={Event.Type.Shutdown}, order=0x7FFFFFFF)
    public void stop() {
        if (this.up.get()) {
            this.httpServer.close(event -> {
                if (event.failed()) {
                    log.error("Failed to stop HttpServer on port {}", (Object)this.httpServer.actualPort(), (Object)event.cause());
                } else {
                    log.info("Stopped HttpServer on port {}", (Object)this.httpServer.actualPort());
                }
                this.up.set(false);
            });
        }
    }

    private void routeException(Throwable throwable) {
        log.error("Routing exception", throwable);
        this.errorCount.inc();
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getHttpIp() {
        return this.httpIp;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public AtomicBoolean getUp() {
        return this.up;
    }

    public Counter getErrorCount() {
        return this.errorCount;
    }
}

