/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.partx.core.utils.Yaml;
import io.partx.core.vertx.Response;
import io.partx.core.vertx.ResponseWriter;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ResponseWriterImpl
implements ResponseWriter {
    private static List<Writer> responseWriters = new LinkedList<Writer>();
    private final List<Writer> produceWriters = new LinkedList<Writer>();

    public ResponseWriterImpl(String[] produceTypes) {
        for (String produceType : produceTypes) {
            for (Writer writer : responseWriters) {
                if (!writer.match(produceType)) continue;
                this.produceWriters.add(writer);
            }
        }
    }

    private void write(RoutingContext routingContext, HttpResponseStatus status, Object response) {
        routingContext.response().setStatusCode(status.code()).setStatusMessage(status.reasonPhrase());
        if (response == null) {
            routingContext.response().end();
        } else {
            Writer writer = null;
            block0: for (MIMEHeader accept : routingContext.parsedHeaders().accept()) {
                for (Writer matchWriter : this.produceWriters) {
                    if (!matchWriter.match(accept)) continue;
                    writer = matchWriter;
                    continue block0;
                }
            }
            if (writer == null) {
                writer = !this.produceWriters.isEmpty() ? this.produceWriters.get(0) : (response instanceof String || response instanceof Number ? Writer.of(null, "text/plain", value -> Buffer.buffer((String)value.toString())) : (response instanceof Buffer ? Writer.of(null, "text/plain", value -> (Buffer)value) : Writer.of(null, "application/json", Json::encodeToBuffer)));
            }
            if (writer != null) {
                routingContext.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)writer.contentType()).end(writer.write(response));
            } else {
                if (routingContext.getAcceptableContentType() != null) {
                    routingContext.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)routingContext.getAcceptableContentType());
                }
                routingContext.response().end(response.toString());
            }
        }
    }

    @Override
    public void write(RoutingContext routingContext, Object response) {
        if (response instanceof Response) {
            this.write(routingContext, ((Response)response).getStatus(), ((Response)response).getData());
        } else if (response instanceof Future) {
            ((Future)response).setHandler(event -> {
                if (event.succeeded()) {
                    this.write(routingContext, event.result());
                } else {
                    routingContext.fail(event.cause());
                }
            });
        } else if (response instanceof CompletableFuture) {
            ((CompletableFuture)((CompletableFuture)response).thenAccept(data -> this.write(routingContext, data))).exceptionally(throwable -> {
                routingContext.fail(throwable);
                return null;
            });
        } else {
            this.write(routingContext, HttpResponseStatus.OK, response);
        }
    }

    static {
        responseWriters.add(Writer.of("*/json", "application/json", Json::encodeToBuffer));
        responseWriters.add(Writer.of("*/yaml", "application/yaml", Yaml::encodeToBuffer));
        responseWriters.add(Writer.of("text/html", "text/html", value -> Buffer.buffer((String)value.toString())));
        responseWriters.add(Writer.of("text/*", "text/plain", value -> Buffer.buffer((String)value.toString())));
    }

    private static interface Writer {
        public String contentType();

        public Buffer write(Object var1);

        public boolean match(MIMEHeader var1);

        default public boolean match(String contentType) {
            return this.match((MIMEHeader)new ParsableMIMEValue(contentType).forceParse());
        }

        public static Writer of(String matchType, final String contentType, final Function<Object, Buffer> encoder) {
            final ParsableMIMEValue parsableMIMEValue = new ParsableMIMEValue(matchType).forceParse();
            return new Writer(){

                @Override
                public String contentType() {
                    return contentType;
                }

                @Override
                public Buffer write(Object value) {
                    return (Buffer)encoder.apply(value);
                }

                @Override
                public boolean match(MIMEHeader mimeHeader) {
                    return Objects.equals(parsableMIMEValue.value(), mimeHeader.value()) || (Objects.equals(parsableMIMEValue.component(), mimeHeader.component()) || Objects.equals(parsableMIMEValue.component(), "*")) && (Objects.equals(parsableMIMEValue.subComponent(), mimeHeader.subComponent()) || Objects.equals(parsableMIMEValue.subComponent(), "*"));
                }
            };
        }
    }
}

