/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.partx.core.ModuleRegistry;
import io.partx.core.annotation.Route;
import io.partx.core.annotation.RouteList;
import io.partx.core.impl.RouteHandler;
import io.partx.core.vertx.ResponseWriter;
import io.partx.core.vertx.ResponseWriterImpl;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteModule
extends AbstractModule {
    private final ModuleRegistry moduleRegistry;

    public RouteModule(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new RouteTypeListener(this.moduleRegistry));
    }

    private static RouteHandler createRouteHandler(Route route, Object origin, Handler<RoutingContext> handler) {
        return RouteHandler.builder().path(route.path()).blocking(route.blocking()).ordered(route.ordered()).method(Sets.newHashSet((Object[])route.method())).regexp(route.regexp()).handler(handler).origin(origin).order(route.order()).produces(Sets.newHashSet((Object[])route.produces())).consumes(Sets.newHashSet((Object[])route.consumes())).build();
    }

    private static class RouteAnnotatedInjector<T>
    implements MembersInjector<T> {
        private static final Logger log = LoggerFactory.getLogger(RouteAnnotatedInjector.class);
        private final boolean isHandlerInstance;
        private final Route route;
        private final ModuleRegistry moduleRegistry;
        private final Method method;
        private final ResponseWriter responseWriter;

        public RouteAnnotatedInjector(Route routeOnClass, Class<?> clazz, ModuleRegistry moduleRegistry) {
            this.route = routeOnClass;
            this.isHandlerInstance = Handler.class.isAssignableFrom(clazz);
            this.moduleRegistry = moduleRegistry;
            this.method = null;
            this.responseWriter = new ResponseWriterImpl(this.route.produces());
        }

        public RouteAnnotatedInjector(Route routeOnMethod, Method method, ModuleRegistry moduleRegistry) {
            this.route = routeOnMethod;
            this.moduleRegistry = moduleRegistry;
            this.method = method;
            this.responseWriter = new ResponseWriterImpl(this.route.produces());
            this.isHandlerInstance = false;
        }

        public void injectMembers(T instance) {
            Set routeHandlerClasses = Sets.newHashSet((Object[])this.route.handler()).stream().filter(handler -> !Handler.class.equals(handler)).collect(Collectors.toSet());
            if (!routeHandlerClasses.isEmpty()) {
                Preconditions.checkState((this.method == null ? 1 : 0) != 0, (Object)("@Route with handler attribute can only used on class: " + this.route));
                for (final Class handlerClass : routeHandlerClasses) {
                    this.moduleRegistry.register(RouteHandler.class, RouteModule.createRouteHandler(this.route, handlerClass, (Handler<RoutingContext>)((Handler)new Handler<RoutingContext>(){
                        private Handler<RoutingContext> delegate;

                        @Inject
                        private void setInjector(Injector injector) {
                            this.delegate = (Handler)injector.getInstance(handlerClass);
                        }

                        public void handle(RoutingContext event) {
                            this.delegate.handle((Object)event);
                        }
                    })));
                }
            } else if (this.isHandlerInstance) {
                this.moduleRegistry.register(RouteHandler.class, RouteModule.createRouteHandler(this.route, instance, (Handler<RoutingContext>)((Handler)instance)));
            } else if (this.method != null) {
                if (Handler.class.isAssignableFrom(this.method.getReturnType())) {
                    try {
                        this.moduleRegistry.register(RouteHandler.class, RouteModule.createRouteHandler(this.route, this.method, (Handler<RoutingContext>)((Handler)this.method.invoke(instance, new Object[0]))));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    this.moduleRegistry.register(RouteHandler.class, RouteModule.createRouteHandler(this.route, this.method, (Handler<RoutingContext>)routingContext -> {
                        try {
                            Object result;
                            int paramCount = this.method.getParameterCount();
                            if (paramCount == 0) {
                                result = this.method.invoke(instance, new Object[0]);
                            } else if (paramCount == 1) {
                                result = this.method.invoke(instance, routingContext);
                            } else {
                                routingContext.fail((Throwable)new IllegalStateException("@Route [Response] handler([RoutingContext context]) should support 0 or 1 param:" + this.method));
                                return;
                            }
                            this.response(result, (RoutingContext)routingContext);
                        }
                        catch (InvocationTargetException e) {
                            routingContext.fail((Throwable)new IllegalStateException("Failed to invoke route handler: " + this.method, e.getCause()));
                        }
                        catch (Throwable e) {
                            routingContext.fail((Throwable)new IllegalStateException("Failed to invoke route handler: " + this.method, e));
                        }
                    }));
                }
            }
        }

        private void response(Object result, RoutingContext routingContext) {
            if (routingContext.response().ended() && result != null) {
                log.warn("Response ended but got: {}", result);
            } else if (result != null) {
                this.responseWriter.write(routingContext, result);
            } else {
                routingContext.response().end();
            }
        }
    }

    private static class RouteTypeListener
    implements TypeListener {
        private final ModuleRegistry moduleRegistry;

        private RouteTypeListener(ModuleRegistry moduleRegistry) {
            this.moduleRegistry = moduleRegistry;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            Class clazz = type.getRawType();
            Route routeOnClass = clazz.getAnnotation(Route.class);
            RouteList routeListOnClass = clazz.getAnnotation(RouteList.class);
            if (routeOnClass != null) {
                encounter.register(new RouteAnnotatedInjector(routeOnClass, clazz, this.moduleRegistry));
            }
            if (routeListOnClass != null) {
                for (Route route : routeListOnClass.value()) {
                    encounter.register(new RouteAnnotatedInjector(route, clazz, this.moduleRegistry));
                }
            }
            for (Method method : clazz.getDeclaredMethods()) {
                Route routeOnMethod = method.getAnnotation(Route.class);
                if (routeOnMethod == null) continue;
                encounter.register(new RouteAnnotatedInjector(routeOnMethod, method, this.moduleRegistry));
            }
        }
    }
}

