/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.EventLoopGroup;
import io.partx.core.Config;
import io.partx.core.Context;
import io.partx.core.Event;
import io.partx.core.Workers;
import io.partx.core.annotation.Listen;
import io.partx.core.vertx.ConfigService;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.MetricsService;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxBundle
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(VertxBundle.class);
    private VertxOptions vertxOptions;
    private DropwizardMetricsOptions metricsOptions;
    private HttpClientOptions httpClientOptions;
    private ConfigRetrieverOptions configRetriever;
    private HttpServerOptions httpServerOptions;
    private ConfigService configUpdater;
    @Inject
    private Context context;
    @Inject
    private Config config;

    protected void configure() {
        final Vertx vertx = Vertx.vertx((VertxOptions)this.vertxOptions);
        if (this.vertxOptions.getMetricsOptions() == null) {
            this.vertxOptions.setMetricsOptions((MetricsOptions)this.metricsOptions);
        } else if (this.vertxOptions.getMetricsOptions() instanceof DropwizardMetricsOptions) {
            this.metricsOptions = (DropwizardMetricsOptions)this.vertxOptions.getMetricsOptions();
        }
        if (this.vertxOptions.getMetricsOptions() != null) {
            this.bind(MetricRegistry.class).toProvider(() -> SharedMetricRegistries.getOrCreate((String)this.metricsOptions.getRegistryName()));
            this.bind(MetricsService.class).toProvider(() -> MetricsService.create((Vertx)vertx)).in(Singleton.class);
        }
        vertx.exceptionHandler(this::handleException);
        this.configUpdater = new ConfigService(this.config, vertx, this.configRetriever);
        this.bind(Vertx.class).toInstance((Object)vertx);
        this.bind(EventBus.class).toProvider(() -> ((Vertx)vertx).eventBus());
        this.bind(FileSystem.class).toProvider(() -> ((Vertx)vertx).fileSystem());
        this.bind(SharedData.class).toProvider(() -> ((Vertx)vertx).sharedData());
        this.bind(EventLoopGroup.class).toProvider(() -> ((Vertx)vertx).nettyEventLoopGroup());
        this.bind(HttpServer.class).toProvider(() -> {
            this.httpServerOptions.setSsl(this.httpServerOptions.isSsl() || this.config.get("http.server.ssl", Boolean.class).orElse(false) != false);
            return vertx.createHttpServer(this.httpServerOptions);
        }).in(Singleton.class);
        this.bind(HttpClient.class).toProvider(() -> {
            this.httpClientOptions.setSsl(this.config.get("http.client.ssl", Boolean.class).orElse(false) != false || this.httpClientOptions.isSsl());
            return vertx.createHttpClient(this.httpClientOptions);
        }).in(Singleton.class);
        this.bind(WorkerExecutor.class).toProvider(() -> vertx.createSharedWorkerExecutor(this.config.get("vertx.worker.name", String.class).orElse("WorkExecutor"), this.config.get("vertx.worker.poolSize", Integer.class).orElse(8).intValue())).in(Singleton.class);
        this.bind(Workers.class).toProvider(() -> new Workers(){

            @Override
            public <T> CompletableFuture<T> execute(Callable<T> runnable, boolean blocking) {
                CompletableFuture promise = new CompletableFuture();
                if (blocking) {
                    VertxBundle.this.context.get(WorkerExecutor.class).executeBlocking(result -> {
                        try {
                            result.complete(runnable.call());
                        }
                        catch (Exception e) {
                            result.fail((Throwable)e);
                        }
                    }, result -> {
                        if (result.succeeded()) {
                            promise.complete(result.result());
                        } else {
                            promise.completeExceptionally(result.cause());
                        }
                    });
                } else {
                    vertx.runOnContext(result -> {
                        try {
                            promise.complete(runnable.call());
                        }
                        catch (Exception e) {
                            promise.completeExceptionally(e);
                        }
                    });
                }
                return promise;
            }
        }).in(Singleton.class);
    }

    private void handleException(Throwable throwable) {
        log.error("Unhandled exception", throwable);
    }

    @Listen(value={Event.Type.Initialize}, order=-2147483648)
    public void init() {
        this.configUpdater.update();
    }

    @Listen(value={Event.Type.Shutdown}, order=-2147483648)
    public void destroy() {
        this.configUpdater.close();
        log.info("Closing vertx");
        this.context.get(Vertx.class).close(event -> {
            if (event.succeeded()) {
                log.info("Succeeded to close vertx");
            } else {
                log.error("Failed to close vertx", event.cause());
            }
        });
    }

    private static VertxOptions $default$vertxOptions() {
        return new VertxOptions().setEventLoopPoolSize(1).setMaxEventLoopExecuteTime(TimeUnit.SECONDS.toNanos(20L)).setBlockedThreadCheckInterval(TimeUnit.SECONDS.toMillis(30L)).setWarningExceptionTime(TimeUnit.SECONDS.toNanos(30L)).setAddressResolverOptions(new AddressResolverOptions().setNdots(3).setCacheMinTimeToLive(300).setCacheNegativeTimeToLive(60));
    }

    private static DropwizardMetricsOptions $default$metricsOptions() {
        return new DropwizardMetricsOptions().setRegistryName("partx").setBaseName("partx").setJmxEnabled(true).setJmxDomain("io.partx");
    }

    private static HttpClientOptions $default$httpClientOptions() {
        return new HttpClientOptions().setKeepAlive(false).setConnectTimeout(5000).setMaxChunkSize(0xA00000).setSsl(false).setTrustAll(true).setIdleTimeout(50).setVerifyHost(false).setTryUseCompression(true);
    }

    private static ConfigRetrieverOptions $default$configRetriever() {
        return new ConfigRetrieverOptions().setIncludeDefaultStores(true);
    }

    private static HttpServerOptions $default$httpServerOptions() {
        return new HttpServerOptions().setSsl(false).setCompressionSupported(true);
    }

    public static VertxBundleBuilder builder() {
        return new VertxBundleBuilder();
    }

    public VertxBundle() {
    }

    @ConstructorProperties(value={"vertxOptions", "metricsOptions", "httpClientOptions", "configRetriever", "httpServerOptions", "configUpdater", "context", "config"})
    public VertxBundle(VertxOptions vertxOptions, DropwizardMetricsOptions metricsOptions, HttpClientOptions httpClientOptions, ConfigRetrieverOptions configRetriever, HttpServerOptions httpServerOptions, ConfigService configUpdater, Context context, Config config) {
        this.vertxOptions = vertxOptions;
        this.metricsOptions = metricsOptions;
        this.httpClientOptions = httpClientOptions;
        this.configRetriever = configRetriever;
        this.httpServerOptions = httpServerOptions;
        this.configUpdater = configUpdater;
        this.context = context;
        this.config = config;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public VertxBundle setVertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
        return this;
    }

    public DropwizardMetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public VertxBundle setMetricsOptions(DropwizardMetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
        return this;
    }

    public HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public VertxBundle setHttpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public ConfigRetrieverOptions getConfigRetriever() {
        return this.configRetriever;
    }

    public VertxBundle setConfigRetriever(ConfigRetrieverOptions configRetriever) {
        this.configRetriever = configRetriever;
        return this;
    }

    public HttpServerOptions getHttpServerOptions() {
        return this.httpServerOptions;
    }

    public VertxBundle setHttpServerOptions(HttpServerOptions httpServerOptions) {
        this.httpServerOptions = httpServerOptions;
        return this;
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
    }

    public static class VertxBundleBuilder {
        private boolean vertxOptions$set;
        private VertxOptions vertxOptions;
        private boolean metricsOptions$set;
        private DropwizardMetricsOptions metricsOptions;
        private boolean httpClientOptions$set;
        private HttpClientOptions httpClientOptions;
        private boolean configRetriever$set;
        private ConfigRetrieverOptions configRetriever;
        private boolean httpServerOptions$set;
        private HttpServerOptions httpServerOptions;
        private ConfigService configUpdater;
        private Context context;
        private Config config;

        VertxBundleBuilder() {
        }

        public VertxBundleBuilder vertxOptions(VertxOptions vertxOptions) {
            this.vertxOptions = vertxOptions;
            this.vertxOptions$set = true;
            return this;
        }

        public VertxBundleBuilder metricsOptions(DropwizardMetricsOptions metricsOptions) {
            this.metricsOptions = metricsOptions;
            this.metricsOptions$set = true;
            return this;
        }

        public VertxBundleBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
            this.httpClientOptions = httpClientOptions;
            this.httpClientOptions$set = true;
            return this;
        }

        public VertxBundleBuilder configRetriever(ConfigRetrieverOptions configRetriever) {
            this.configRetriever = configRetriever;
            this.configRetriever$set = true;
            return this;
        }

        public VertxBundleBuilder httpServerOptions(HttpServerOptions httpServerOptions) {
            this.httpServerOptions = httpServerOptions;
            this.httpServerOptions$set = true;
            return this;
        }

        public VertxBundleBuilder configUpdater(ConfigService configUpdater) {
            this.configUpdater = configUpdater;
            return this;
        }

        public VertxBundleBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public VertxBundleBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public VertxBundle build() {
            return new VertxBundle(this.vertxOptions$set ? this.vertxOptions : VertxBundle.$default$vertxOptions(), this.metricsOptions$set ? this.metricsOptions : VertxBundle.$default$metricsOptions(), this.httpClientOptions$set ? this.httpClientOptions : VertxBundle.$default$httpClientOptions(), this.configRetriever$set ? this.configRetriever : VertxBundle.$default$configRetriever(), this.httpServerOptions$set ? this.httpServerOptions : VertxBundle.$default$httpServerOptions(), this.configUpdater, this.context, this.config);
        }

        public String toString() {
            return "VertxBundle.VertxBundleBuilder(vertxOptions=" + this.vertxOptions + ", metricsOptions=" + this.metricsOptions + ", httpClientOptions=" + this.httpClientOptions + ", configRetriever=" + this.configRetriever + ", httpServerOptions=" + this.httpServerOptions + ", configUpdater=" + this.configUpdater + ", context=" + this.context + ", config=" + this.config + ")";
        }
    }
}

