/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.FaviconHandler;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public class VertxWebBundle
extends AbstractModule {
    private String faviconPath;
    private long faviconMaxAgeSeconds;
    private String bodyUploadDirectory;
    private String errorTemplate;
    private boolean enableErrorDetails;
    private final List<Runnable> lazyBinding = new LinkedList<Runnable>();

    public <T extends Handler<RoutingContext>> VertxWebBundle bind(Class<T> type, Provider<T> provider) {
        if (provider != null) {
            this.lazyBinding.add(() -> this.bind(type).toProvider(provider).in(Singleton.class));
        }
        return this;
    }

    public <T extends Handler<RoutingContext>> VertxWebBundle bind(Class<T> type, T instance) {
        if (instance != null) {
            this.lazyBinding.add(() -> this.bind(type).toInstance((Object)instance));
        }
        return this;
    }

    protected void configure() {
        this.bind(ChainAuthHandler.class, ChainAuthHandler.create());
        this.bind(CookieHandler.class, CookieHandler.create());
        this.bind((Class)BodyHandler.class, (Handler)((Provider)() -> {
            if (this.bodyUploadDirectory != null) {
                return BodyHandler.create((String)this.bodyUploadDirectory);
            }
            return BodyHandler.create();
        }));
        this.bind((Class)ErrorHandler.class, (Handler)((Provider)() -> this.errorTemplate != null ? ErrorHandler.create((String)this.errorTemplate, (boolean)this.enableErrorDetails) : ErrorHandler.create((boolean)this.enableErrorDetails)));
        this.bind((Class)FaviconHandler.class, (Handler)((Provider)() -> {
            if (this.faviconPath != null && this.faviconMaxAgeSeconds > 0L) {
                return FaviconHandler.create((String)this.faviconPath, (long)this.faviconMaxAgeSeconds);
            }
            if (this.faviconPath != null) {
                return FaviconHandler.create((String)this.faviconPath);
            }
            if (this.faviconMaxAgeSeconds > 0L) {
                return FaviconHandler.create((long)this.faviconMaxAgeSeconds);
            }
            return FaviconHandler.create();
        }));
        this.lazyBinding.forEach(Runnable::run);
    }

    public static VertxWebBundleBuilder builder() {
        return new VertxWebBundleBuilder();
    }

    public VertxWebBundle() {
    }

    @ConstructorProperties(value={"faviconPath", "faviconMaxAgeSeconds", "bodyUploadDirectory", "errorTemplate", "enableErrorDetails"})
    public VertxWebBundle(String faviconPath, long faviconMaxAgeSeconds, String bodyUploadDirectory, String errorTemplate, boolean enableErrorDetails) {
        this.faviconPath = faviconPath;
        this.faviconMaxAgeSeconds = faviconMaxAgeSeconds;
        this.bodyUploadDirectory = bodyUploadDirectory;
        this.errorTemplate = errorTemplate;
        this.enableErrorDetails = enableErrorDetails;
    }

    public void setFaviconPath(String faviconPath) {
        this.faviconPath = faviconPath;
    }

    public void setFaviconMaxAgeSeconds(long faviconMaxAgeSeconds) {
        this.faviconMaxAgeSeconds = faviconMaxAgeSeconds;
    }

    public void setBodyUploadDirectory(String bodyUploadDirectory) {
        this.bodyUploadDirectory = bodyUploadDirectory;
    }

    public void setErrorTemplate(String errorTemplate) {
        this.errorTemplate = errorTemplate;
    }

    public void setEnableErrorDetails(boolean enableErrorDetails) {
        this.enableErrorDetails = enableErrorDetails;
    }

    public static class VertxWebBundleBuilder {
        private String faviconPath;
        private long faviconMaxAgeSeconds;
        private String bodyUploadDirectory;
        private String errorTemplate;
        private boolean enableErrorDetails;

        VertxWebBundleBuilder() {
        }

        public VertxWebBundleBuilder faviconPath(String faviconPath) {
            this.faviconPath = faviconPath;
            return this;
        }

        public VertxWebBundleBuilder faviconMaxAgeSeconds(long faviconMaxAgeSeconds) {
            this.faviconMaxAgeSeconds = faviconMaxAgeSeconds;
            return this;
        }

        public VertxWebBundleBuilder bodyUploadDirectory(String bodyUploadDirectory) {
            this.bodyUploadDirectory = bodyUploadDirectory;
            return this;
        }

        public VertxWebBundleBuilder errorTemplate(String errorTemplate) {
            this.errorTemplate = errorTemplate;
            return this;
        }

        public VertxWebBundleBuilder enableErrorDetails(boolean enableErrorDetails) {
            this.enableErrorDetails = enableErrorDetails;
            return this;
        }

        public VertxWebBundle build() {
            return new VertxWebBundle(this.faviconPath, this.faviconMaxAgeSeconds, this.bodyUploadDirectory, this.errorTemplate, this.enableErrorDetails);
        }

        public String toString() {
            return "VertxWebBundle.VertxWebBundleBuilder(faviconPath=" + this.faviconPath + ", faviconMaxAgeSeconds=" + this.faviconMaxAgeSeconds + ", bodyUploadDirectory=" + this.bodyUploadDirectory + ", errorTemplate=" + this.errorTemplate + ", enableErrorDetails=" + this.enableErrorDetails + ")";
        }
    }
}

