/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
implements Serializable {
    private Type type;
    private Throwable cause;
    private Object address;
    private boolean reversed;
    private boolean expired;
    private Delivery delivery;
    public static Event Construct = Event.builder().type(Type.Construct).build();
    public static Event Initialize = Event.builder().type(Type.Initialize).build();
    public static Event Start = Event.builder().type(Type.Start).build();
    public static Event Shutdown = Event.builder().type(Type.Shutdown).reversed(true).build();

    public Event copy() {
        return Event.builder().type(this.type).cause(this.cause).address(this.address).expired(this.expired).delivery(this.delivery).build();
    }

    private static Delivery $default$delivery() {
        return Delivery.BestEffort;
    }

    public static EventBuilder builder() {
        return new EventBuilder();
    }

    public String toString() {
        return "Event(type=" + (Object)((Object)this.getType()) + ", cause=" + this.getCause() + ", address=" + this.getAddress() + ", reversed=" + this.isReversed() + ", expired=" + this.isExpired() + ", delivery=" + (Object)((Object)this.getDelivery()) + ")";
    }

    public Event() {
    }

    @ConstructorProperties(value={"type", "cause", "address", "reversed", "expired", "delivery"})
    public Event(Type type, Throwable cause, Object address, boolean reversed, boolean expired, Delivery delivery) {
        this.type = type;
        this.cause = cause;
        this.address = address;
        this.reversed = reversed;
        this.expired = expired;
        this.delivery = delivery;
    }

    public Type getType() {
        return this.type;
    }

    public Event setType(Type type) {
        this.type = type;
        return this;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Event setCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public Object getAddress() {
        return this.address;
    }

    public Event setAddress(Object address) {
        this.address = address;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Event setReversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Event setExpired(boolean expired) {
        this.expired = expired;
        return this;
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public Event setDelivery(Delivery delivery) {
        this.delivery = delivery;
        return this;
    }

    public static class EventBuilder {
        private Type type;
        private Throwable cause;
        private Object address;
        private boolean reversed;
        private boolean expired;
        private boolean delivery$set;
        private Delivery delivery;

        EventBuilder() {
        }

        public EventBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public EventBuilder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public EventBuilder address(Object address) {
            this.address = address;
            return this;
        }

        public EventBuilder reversed(boolean reversed) {
            this.reversed = reversed;
            return this;
        }

        public EventBuilder expired(boolean expired) {
            this.expired = expired;
            return this;
        }

        public EventBuilder delivery(Delivery delivery) {
            this.delivery = delivery;
            this.delivery$set = true;
            return this;
        }

        public Event build() {
            return new Event(this.type, this.cause, this.address, this.reversed, this.expired, this.delivery$set ? this.delivery : Event.$default$delivery());
        }

        public String toString() {
            return "Event.EventBuilder(type=" + (Object)((Object)this.type) + ", cause=" + this.cause + ", address=" + this.address + ", reversed=" + this.reversed + ", expired=" + this.expired + ", delivery=" + (Object)((Object)this.delivery) + ")";
        }
    }

    public static enum Type {
        Construct,
        Initialize,
        Start,
        Shutdown,
        Failure;

    }

    public static enum Delivery {
        BestEffort,
        FailFast;

    }
}

