/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.annotation;

import io.partx.core.annotation.RouteList;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Repeatable(value=RouteList.class)
public @interface Route {
    public String value() default "";

    public boolean regexp() default false;

    public HttpMethod[] method() default {HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.TRACE, HttpMethod.CONNECT, HttpMethod.PATCH, HttpMethod.OTHER};

    public boolean blocking() default false;

    public int order() default -1000;

    public Class<?>[] handler() default {Handler.class};

    public boolean ordered() default true;

    public String[] produces() default {"application/json"};

    public String[] consumes() default {"*/*"};

    public static interface Order {
        public static final int FIRST = Integer.MIN_VALUE;
        public static final int BEFORE = -1000;
        public static final int AFTER = 1000;
        public static final int LAST = Integer.MAX_VALUE;
    }
}

