/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import io.partx.core.Config;
import io.partx.core.utils.JsonModifier;
import io.vertx.config.ConfigChange;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ConfigImpl
implements Config,
Handler<ConfigChange> {
    private final JsonModifier staticJson = new JsonModifier(new JsonObject());
    private final List<Handler<ConfigChange>> listeners = new LinkedList<Handler<ConfigChange>>();
    private volatile JsonObject dynamicJson = new JsonObject();

    @Override
    public JsonObject json() {
        return this.dynamicJson.copy().mergeIn(this.staticJson.json(), true);
    }

    @Override
    public <T> Config set(String jsonPath, T value) {
        this.staticJson.set(jsonPath, value);
        return this;
    }

    @Override
    public Config set(JsonObject jsonObject) {
        this.staticJson.patch(jsonObject);
        return this;
    }

    @Override
    public <T> Optional<T> get(String jsonPath) {
        return new JsonModifier(this.json()).resolve(jsonPath).map(o -> o);
    }

    @Override
    public <T> Optional<T> get(String jsonPath, Class<T> typeClass) {
        return new JsonModifier(this.json()).resolve(jsonPath, typeClass);
    }

    @Override
    public <T> Optional<T> get(String jsonPath, TypeReference<T> typeRef) {
        return new JsonModifier(this.json()).resolve(jsonPath, typeRef);
    }

    @Override
    public boolean contains(String jsonPath) {
        return new JsonModifier(this.json()).resolve(jsonPath).isPresent();
    }

    @Override
    public <T> Config put(String jsonPath, T value) {
        this.staticJson.put(jsonPath, new JsonObject(Json.encode(value)));
        return this;
    }

    @Override
    public Config listen(Handler<ConfigChange> handler) {
        this.listeners.add(handler);
        return this;
    }

    public void handle(ConfigChange event) {
        ConfigChange configChange = new ConfigChange();
        configChange.setPreviousConfiguration(this.json());
        this.dynamicJson = event.getNewConfiguration().copy();
        configChange.setNewConfiguration(this.json());
        this.listeners.forEach(listener -> listener.handle((Object)configChange));
    }
}

