/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.internal;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.partx.core.Config;
import io.partx.core.Event;
import io.partx.core.EventListener;
import io.partx.core.annotation.Listener;
import io.partx.core.annotation.Property;
import io.partx.core.internal.ConfigHandler;
import io.partx.core.internal.EventHandler;
import io.partx.core.internal.MetricHandler;
import io.partx.core.internal.ModuleRegistry;
import io.partx.core.utils.FastReflect;
import io.partx.core.utils.Yaml;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class KernalModule
extends AbstractModule {
    private final ModuleRegistry moduleRegistry;

    public KernalModule(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new AnnotationTypeListener(this.moduleRegistry));
    }

    private static class ConfigAnnotatedInjector<T>
    implements MembersInjector<T> {
        private final Property property;
        private final ModuleRegistry moduleRegistry;
        private final ValueSetter<T> setter;

        private ConfigAnnotatedInjector(Property property, final Field field, ModuleRegistry moduleRegistry) {
            this.property = property;
            this.moduleRegistry = moduleRegistry;
            final String name = field.getName();
            final Class<?> type = field.getType();
            field.setAccessible(true);
            this.setter = new ValueSetter<T>(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public Object getInitialValue(T instance) {
                    try {
                        return field.get(instance);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Failed to get initial value of field " + field + " in " + instance, e);
                    }
                }

                @Override
                public Class<?> getType() {
                    return type;
                }

                @Override
                public void updateValue(T instance, Object value) {
                    try {
                        field.set(instance, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Failed to set value for field " + field + " in " + instance);
                    }
                }
            };
        }

        private ConfigAnnotatedInjector(Property property, final Method method, ModuleRegistry moduleRegistry) {
            this.moduleRegistry = moduleRegistry;
            this.property = property;
            final String methodName = method.getName();
            final FastReflect.Function1 methodInvoker = FastReflect.getInstance().invoke1(method);
            Preconditions.checkState((method.getParameterCount() != 1 ? 1 : 0) != 0, (Object)"@Conf(name) void setConfig(Type value) should has only single parameter");
            final Class<?> returnType = method.getParameterTypes()[0];
            this.setter = new ValueSetter<T>(){

                @Override
                public String getName() {
                    return methodName;
                }

                @Override
                public Class<?> getType() {
                    return returnType;
                }

                @Override
                public void updateValue(T instance, Object value) {
                    try {
                        methodInvoker.invoke(instance, value);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Failed to invoke listener: " + method, e.getCause());
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("Failed to invoke listener: " + method, e);
                    }
                }
            };
        }

        public void injectMembers(final T instance) {
            Object initialValue = this.setter.getInitialValue(instance);
            final String name = !StringUtils.isBlank((CharSequence)this.property.name()) ? this.property.name() : this.property.value();
            this.moduleRegistry.register(ConfigHandler.class, ConfigHandler.builder().name(name).type(this.setter.getType()).sys(this.property.sys()).env(this.property.env()).defaultValue(this.property.defaultValue()).initialValue(initialValue).updater(new Runnable(){
                @Inject
                private Injector injector;

                @Override
                public void run() {
                    String envValue;
                    String sysValue;
                    Preconditions.checkNotNull((Object)this.injector, (Object)"Injector not set up");
                    Config config = (Config)this.injector.getInstance(Config.class);
                    if (!StringUtils.isEmpty((CharSequence)name) && ((Config)this.injector.getInstance(Config.class)).contains(name)) {
                        Optional<?> opt = config.get(name, setter.getType());
                        if (opt.isPresent()) {
                            setter.updateValue(instance, opt.get());
                            return;
                        }
                        return;
                    }
                    if (!StringUtils.isEmpty((CharSequence)property.sys()) && (sysValue = System.getProperty(property.sys())) != null) {
                        this.setFieldValue(instance, sysValue, "system");
                        return;
                    }
                    if (!StringUtils.isEmpty((CharSequence)property.env()) && (envValue = System.getenv(property.env())) != null) {
                        this.setFieldValue(instance, envValue, "env");
                        return;
                    }
                    if (!StringUtils.isEmpty((CharSequence)property.defaultValue())) {
                        this.setFieldValue(instance, property.defaultValue(), "default");
                    }
                }
            }).resetter(() -> {
                try {
                    this.setter.resetValue(instance, initialValue);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to reset " + this.setter.getName() + " in " + instance, e);
                }
            }).build());
        }

        private void setFieldValue(T instance, String strValue, String from) {
            try {
                this.setter.updateValue(instance, Yaml.decodeValue(strValue, this.setter.getType()));
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to set value: " + this.setter.getName() + " = " + strValue + " (" + from + ") in " + instance, e);
            }
        }

        public static interface ValueSetter<S> {
            public String getName();

            default public Object getInitialValue(S instance) {
                return null;
            }

            public Class<?> getType();

            public void updateValue(S var1, Object var2);

            default public void resetValue(S instance, Object initialValue) {
            }
        }
    }

    private static class ListenerAnnotatedInjector<T>
    implements MembersInjector<T> {
        private final ModuleRegistry moduleRegistry;
        private final Listener listener;
        private final Method method;
        private final Class<?> clazz;

        private ListenerAnnotatedInjector(Listener listener, Class<?> clazz, ModuleRegistry moduleRegistry) {
            this.moduleRegistry = moduleRegistry;
            this.listener = listener;
            this.method = null;
            this.clazz = clazz;
        }

        private ListenerAnnotatedInjector(Listener listener, Method method, ModuleRegistry moduleRegistry) {
            this.moduleRegistry = moduleRegistry;
            this.listener = listener;
            this.method = method;
            this.clazz = null;
        }

        public void injectMembers(T instance) {
            if (this.clazz != null) {
                this.moduleRegistry.register(EventHandler.class, EventHandler.builder().type(Sets.newHashSet((Object[])this.listener.value())).expect(this.listener.expect().length == 0 || this.listener.expect().length == 1 && this.listener.expect()[0].equals(Object.class) ? Collections.emptySet() : Sets.newHashSet((Object[])this.listener.expect())).instance(instance).order(this.listener.order()).listener((EventListener)instance).build());
            } else if (this.method != null) {
                this.moduleRegistry.register(EventHandler.class, ListenerAnnotatedInjector.createMethodEventListener(this.listener, this.method, instance));
            }
        }

        private static <I> EventHandler createMethodEventListener(Listener listener, Method method, I instance) {
            Preconditions.checkState((boolean)Modifier.isPublic(method.getClass().getModifiers()), (Object)("Method class not public for access: " + method));
            Preconditions.checkState((boolean)Modifier.isPublic(method.getModifiers()), (Object)("Method not public for access: " + method));
            int paramCount = method.getParameterCount();
            boolean isThrowable = false;
            Preconditions.checkState((paramCount == 0 || paramCount == 1 ? 1 : 0) != 0, (Object)("Invalid @Listen method parameter num: " + method));
            if (paramCount == 1) {
                boolean isEvent = Event.class.isAssignableFrom(method.getParameterTypes()[0]);
                isThrowable = Throwable.class.isAssignableFrom(method.getParameterTypes()[0]);
                Preconditions.checkState((isEvent || isThrowable ? 1 : 0) != 0, (Object)("Invalid @Listen method parameter type: " + method));
            }
            EventHandler.EventHandlerBuilder builder = EventHandler.builder().instance(instance).type(Sets.newHashSet((Object[])listener.value())).expect(listener.expect().length == 0 || listener.expect().length == 1 && listener.expect()[0].equals(Object.class) ? Collections.emptySet() : Sets.newHashSet((Object[])listener.expect())).order(listener.order());
            if (paramCount == 0) {
                FastReflect.Function0 methodInvoker = FastReflect.getInstance().invoke0(method);
                return builder.listener(event -> {
                    try {
                        methodInvoker.invoke(instance);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e.getCause());
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("Failed to invoke listener: " + method, e);
                    }
                }).build();
            }
            if (isThrowable) {
                FastReflect.Function1 methodInvoker = FastReflect.getInstance().invoke1(method);
                return builder.listener(event -> {
                    try {
                        methodInvoker.invoke(instance, event.getCause());
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e.getCause());
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException(e);
                    }
                }).build();
            }
            FastReflect.Function1 methodInvoker = FastReflect.getInstance().invoke1(method);
            return builder.listener(event -> {
                try {
                    methodInvoker.invoke(instance, event);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke listener: " + method, e);
                }
            }).build();
        }
    }

    private static class MetricAnnotatedInjector<T>
    implements MembersInjector<T> {
        private final ModuleRegistry moduleRegistry;
        private final io.partx.core.annotation.Metric metric;
        private final Function<T, Metric> metricGetter;
        private final Object origin;

        private MetricAnnotatedInjector(io.partx.core.annotation.Metric metric, ModuleRegistry moduleRegistry, Method method) {
            this.metric = metric;
            this.moduleRegistry = moduleRegistry;
            this.origin = method;
            FastReflect.Function0 metricGetter = FastReflect.getInstance().invoke0(method);
            this.metricGetter = method.getReturnType().isAssignableFrom(Metric.class) ? t -> {
                try {
                    return (Metric)metricGetter.invoke(t);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke listener: " + method, e);
                }
            } : t -> () -> {
                try {
                    return metricGetter.invoke(t);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Failed to invoke listener: " + method, e.getCause());
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke listener: " + method, e);
                }
            };
        }

        private MetricAnnotatedInjector(io.partx.core.annotation.Metric metric, ModuleRegistry moduleRegistry, Field field) {
            this.metric = metric;
            this.moduleRegistry = moduleRegistry;
            this.origin = field;
            field.setAccessible(true);
            this.metricGetter = Metric.class.isAssignableFrom(field.getType()) ? t -> {
                try {
                    return (Metric)field.get(t);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke @Metric field: " + field, e);
                }
            } : t -> new FieldGauge(field, t);
        }

        public void injectMembers(T instance) {
            this.moduleRegistry.register(MetricHandler.class, MetricHandler.builder().name(this.metric.value()).origin(this.origin).getter(() -> this.metricGetter.apply(instance)).build());
        }

        private static class FieldGauge
        implements Gauge<Object> {
            private final Field field;
            private final Object instance;

            public FieldGauge(Field field, Object instance) {
                this.field = field;
                this.instance = instance;
            }

            public boolean equals(Object obj) {
                return obj instanceof FieldGauge && ((FieldGauge)obj).field == this.field && ((FieldGauge)obj).instance == this.instance;
            }

            public int hashCode() {
                return new HashCodeBuilder().append((Object)this.field).append(this.instance).build();
            }

            public Object getValue() {
                try {
                    return this.field.get(this.instance);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke @Metric field: " + this.field, e);
                }
            }
        }
    }

    private static class AnnotationTypeListener
    implements TypeListener {
        private final ModuleRegistry moduleRegistry;

        private AnnotationTypeListener(ModuleRegistry moduleRegistry) {
            this.moduleRegistry = moduleRegistry;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            Class clazz = type.getRawType();
            Listener listenerListenerClass = clazz.getAnnotation(Listener.class);
            if (listenerListenerClass != null) {
                if (EventListener.class.isAssignableFrom(clazz)) {
                    encounter.register(new ListenerAnnotatedInjector(listenerListenerClass, clazz, this.moduleRegistry));
                } else {
                    throw new IllegalStateException("@Listen can only use with class implement " + EventListener.class.getName() + ", but used in " + clazz.getName());
                }
            }
            for (Method method : clazz.getDeclaredMethods()) {
                Property propertyOnMethod = method.getAnnotation(Property.class);
                Listener listenerListenerMethod = method.getAnnotation(Listener.class);
                io.partx.core.annotation.Metric metricOnMethod = method.getAnnotation(io.partx.core.annotation.Metric.class);
                if (propertyOnMethod != null) {
                    encounter.register(new ConfigAnnotatedInjector(propertyOnMethod, method, this.moduleRegistry));
                }
                if (listenerListenerMethod != null) {
                    encounter.register(new ListenerAnnotatedInjector(listenerListenerMethod, method, this.moduleRegistry));
                }
                if (metricOnMethod == null) continue;
                encounter.register(new MetricAnnotatedInjector(metricOnMethod, this.moduleRegistry, method));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                Property propertyOnField = ((Field)accessibleObject).getAnnotation(Property.class);
                io.partx.core.annotation.Metric metricOnField = ((Field)accessibleObject).getAnnotation(io.partx.core.annotation.Metric.class);
                if (propertyOnField != null) {
                    encounter.register(new ConfigAnnotatedInjector(propertyOnField, (Field)accessibleObject, this.moduleRegistry));
                }
                if (metricOnField == null) continue;
                encounter.register(new MetricAnnotatedInjector(metricOnField, this.moduleRegistry, (Field)accessibleObject));
            }
        }
    }
}

