/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import io.partx.core.Config;
import io.partx.core.Metadata;
import io.partx.core.Particle;
import io.partx.core.Partx;
import io.partx.core.internal.ConfigImpl;
import io.partx.core.internal.ModuleContext;
import io.partx.core.internal.ParticleImpl;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartxImpl
implements Partx {
    private static final Logger log = LoggerFactory.getLogger(PartxImpl.class);
    private final List<Module> requiredModules = new ArrayList<Module>();
    private final List<Class<?>> managedTypes = new ArrayList();
    private final List<Object> managedPojos = new ArrayList<Object>();
    private final List<Consumer<Binder>> extensions = new ArrayList<Consumer<Binder>>();
    private final Metadata metadata;
    private final Config config = new ConfigImpl();

    public PartxImpl(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Partx set(JsonObject config) {
        this.config.set(config);
        return this;
    }

    @Override
    public <T> Partx set(String jsonPath, T value) {
        this.config.set(jsonPath, value);
        return this;
    }

    @Override
    public <T> Partx put(String key, T value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public <T> Partx use(Class<T> type, Provider<T> provider) {
        this.extensions.add(binder -> binder.bind(type).toProvider(provider).in(Singleton.class));
        return this;
    }

    @Override
    public <T> Partx use(String name, Class<T> type, Provider<T> provider) {
        this.extensions.add(binder -> binder.bind(type).annotatedWith((Annotation)Names.named((String)name)).toProvider(provider));
        return this;
    }

    @Override
    public Partx use(Module ... modules) {
        if (modules != null) {
            this.requiredModules.addAll(Arrays.asList(modules));
        }
        return this;
    }

    @Override
    public Partx use(Class<?> ... services) {
        if (services != null) {
            this.managedTypes.addAll(Arrays.asList(services));
        }
        return this;
    }

    @Override
    public Partx use(Object ... instances) {
        if (instances != null) {
            for (Object instance : instances) {
                if (instance instanceof Module) {
                    this.use((Module)instance);
                    continue;
                }
                if (instance instanceof Class) {
                    this.run((Class)instance);
                    continue;
                }
                if (instance instanceof String) {
                    this.use(instance);
                    continue;
                }
                this.managedPojos.add(instance);
            }
        }
        return this;
    }

    @Override
    public Particle run(Class<?> ... services) {
        this.use(services);
        return this.run();
    }

    @Override
    public Particle run() {
        this.requiredModules.add((Module)new AbstractModule(){

            protected void configure() {
                PartxImpl.this.extensions.forEach(ext -> ext.accept(this.binder()));
            }
        });
        final ParticleImpl context = new ParticleImpl(this.metadata, this.config);
        context.init(new ModuleContext.Builder().root(Collections.singletonList(new AbstractModule(){

            protected void configure() {
                this.bind(Particle.class).toInstance((Object)context);
                this.bind(Config.class).toInstance((Object)PartxImpl.this.config);
            }
        })).modules(this.requiredModules).classes(this.managedTypes).objects(this.managedPojos).build());
        context.start();
        return context;
    }

    @Override
    public Particle run(String[] args) {
        return this.run();
    }

    public List<Module> getRequiredModules() {
        return this.requiredModules;
    }

    public List<Class<?>> getManagedTypes() {
        return this.managedTypes;
    }
}

