/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import io.partx.core.metric.MetricInfo;
import io.partx.core.metric.Metrics;
import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardMetricExports
extends Collector
implements Collector.Describable {
    private static final Logger log = LoggerFactory.getLogger(DropwizardMetricExports.class);
    private final MetricRegistry registry;
    private Metrics metricsInfo;
    private SampleBuilder sampleBuilder;

    public DropwizardMetricExports(MetricRegistry registry, Metrics metricsInfo) {
        this.registry = registry;
        this.sampleBuilder = new DefaultSampleBuilder();
        this.metricsInfo = metricsInfo;
    }

    public DropwizardMetricExports(MetricRegistry registry, Metrics metricsInfo, SampleBuilder sampleBuilder) {
        this.registry = registry;
        this.metricsInfo = metricsInfo;
        this.sampleBuilder = sampleBuilder;
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from partx metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    Collector.MetricFamilySamples fromCounter(MetricInfo metricInfo, Counter counter) {
        String metricName = metricInfo.getPrometheusMetricName();
        Map<String, String> tags = metricInfo.getTags();
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(metricName, "", new ArrayList<String>(tags.keySet()), new ArrayList<String>(tags.values()), new Long(counter.getCount()).doubleValue());
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.GAUGE, DropwizardMetricExports.getHelpMessage(metricName, (Metric)counter), Collections.singletonList(sample));
    }

    Collector.MetricFamilySamples fromGauge(MetricInfo metricInfo, Gauge gauge) {
        double value;
        String metricName = metricInfo.getPrometheusMetricName();
        Map<String, String> tags = metricInfo.getTags();
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else if (obj instanceof AtomicBoolean) {
            value = ((AtomicBoolean)obj).get() ? 1.0 : 0.0;
        } else {
            log.info(String.format("Invalid type for Gauge %s: %s", DropwizardMetricExports.sanitizeMetricName((String)metricName), obj == null ? "null" : obj.getClass().getName()));
            return null;
        }
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(metricName, "", new ArrayList<String>(tags.keySet()), new ArrayList<String>(tags.values()), value);
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.GAUGE, DropwizardMetricExports.getHelpMessage(metricName, (Metric)gauge), Collections.singletonList(sample));
    }

    Collector.MetricFamilySamples fromSnapshotAndCount(String metricName, Snapshot snapshot, long count, double factor, String helpMessage, Map<String, String> tags) {
        ImmutableList labelNames = ImmutableList.builder().addAll(tags.keySet()).add((Object)"quantile").build();
        Function<String, List> labelVales = last -> ImmutableList.builder().addAll(tags.values()).add(last).build();
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.5"), snapshot.getMedian() * factor), this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.75"), snapshot.get75thPercentile() * factor), this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.95"), snapshot.get95thPercentile() * factor), this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.98"), snapshot.get98thPercentile() * factor), this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.99"), snapshot.get99thPercentile() * factor), this.sampleBuilder.createSample(metricName, "", (List)labelNames, labelVales.apply("0.999"), snapshot.get999thPercentile() * factor), this.sampleBuilder.createSample(metricName, "_count", new ArrayList<String>(tags.keySet()), new ArrayList<String>(tags.values()), (double)count));
        return new Collector.MetricFamilySamples(samples.get((int)0).name, Collector.Type.SUMMARY, helpMessage, samples);
    }

    Collector.MetricFamilySamples fromHistogram(MetricInfo metricInfo, Histogram histogram) {
        String metricName = metricInfo.getPrometheusMetricName();
        return this.fromSnapshotAndCount(metricName, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardMetricExports.getHelpMessage(metricName, (Metric)histogram), metricInfo.getTags());
    }

    Collector.MetricFamilySamples fromTimer(MetricInfo metricInfo, Timer timer) {
        String metricName = metricInfo.getPrometheusMetricName();
        return this.fromSnapshotAndCount(metricName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardMetricExports.getHelpMessage(metricName, (Metric)timer), metricInfo.getTags());
    }

    Collector.MetricFamilySamples fromMeter(MetricInfo metricInfo, Meter meter) {
        String metricName = metricInfo.getPrometheusMetricName();
        Map<String, String> tags = metricInfo.getTags();
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(metricName, "_total", new ArrayList<String>(tags.keySet()), new ArrayList<String>(tags.values()), (double)meter.getCount());
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.COUNTER, DropwizardMetricExports.getHelpMessage(metricName, (Metric)meter), Collections.singletonList(sample));
    }

    public List<Collector.MetricFamilySamples> collect() {
        HashMap<String, Collector.MetricFamilySamples> mfSamplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        for (Map.Entry entry : this.registry.getGauges().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromGauge(this.metricsInfo.metric((Metric)entry.getValue()), (Gauge)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getCounters().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromCounter(this.metricsInfo.metric((Metric)entry.getValue()), (Counter)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getHistograms().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromHistogram(this.metricsInfo.metric((Metric)entry.getValue()), (Histogram)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getTimers().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromTimer(this.metricsInfo.metric((Metric)entry.getValue()), (Timer)entry.getValue()));
        }
        for (Map.Entry entry : this.registry.getMeters().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromMeter(this.metricsInfo.metric((Metric)entry.getValue()), (Meter)entry.getValue()));
        }
        return new ArrayList<Collector.MetricFamilySamples>(mfSamplesMap.values());
    }

    private void addToMap(Map<String, Collector.MetricFamilySamples> mfSamplesMap, Collector.MetricFamilySamples newMfSamples) {
        if (newMfSamples != null) {
            Collector.MetricFamilySamples currentMfSamples = mfSamplesMap.get(newMfSamples.name);
            if (currentMfSamples == null) {
                mfSamplesMap.put(newMfSamples.name, newMfSamples);
            } else {
                ArrayList samples = new ArrayList(currentMfSamples.samples);
                samples.addAll(newMfSamples.samples);
                mfSamplesMap.put(newMfSamples.name, new Collector.MetricFamilySamples(newMfSamples.name, currentMfSamples.type, currentMfSamples.help, samples));
            }
        }
    }

    public List<Collector.MetricFamilySamples> describe() {
        return new ArrayList<Collector.MetricFamilySamples>();
    }
}

