/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.metric;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import io.partx.core.metric.MetricInfo;
import io.partx.core.metric.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MetricsImpl
implements Metrics {
    private final MetricRegistry metricRegistry;
    private final Map<Metric, MetricInfo> metricMetricInfoMap = new HashMap<Metric, MetricInfo>();

    public MetricsImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public synchronized <T extends Metric> T metric(T metric, String name, Map<String, String> tags) {
        Preconditions.checkNotNull(metric, (Object)"metric");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(tags, (Object)"tags");
        MetricInfo newInfo = MetricInfo.builder().name(name).metric(metric).tags(new LinkedHashMap<String, String>(tags)).build();
        MetricInfo oldInfo = this.metricMetricInfoMap.get(metric);
        if (oldInfo == null || !oldInfo.equals(newInfo)) {
            if (oldInfo != null) {
                this.metricRegistry.remove(oldInfo.getMetricId());
            }
            this.metricRegistry.register(newInfo.getMetricId(), metric);
            this.metricMetricInfoMap.put(metric, newInfo);
        }
        return metric;
    }

    @Override
    public synchronized <T extends Metric> T metric(T metric, Map<String, String> tags) {
        if (this.metricMetricInfoMap.containsKey(metric)) {
            this.metricMetricInfoMap.get(metric).setTags(new LinkedHashMap<String, String>(tags));
            return metric;
        }
        throw new IllegalArgumentException("Metric not registered and not @Metric annotated yet: " + metric);
    }

    @Override
    public synchronized <T extends Metric> T metric(Supplier<T> metric, String name, Map<String, String> tags) {
        MetricInfo oldInfo = MetricInfo.builder().name(name).tags(tags).build();
        Metric oldMetric = (Metric)this.metricRegistry.getMetrics().get(oldInfo.getMetricId());
        if (oldMetric == null) {
            MetricInfo<Metric> newInfo = MetricInfo.builder().name(name).metric((Metric)metric.get()).tags(new LinkedHashMap<String, String>(tags)).build();
            this.metricRegistry.register(newInfo.getMetricId(), newInfo.getMetric());
            this.metricMetricInfoMap.put(newInfo.getMetric(), newInfo);
            return (T)newInfo.getMetric();
        }
        return (T)oldMetric;
    }

    @Override
    public synchronized boolean remove(Metric metric) {
        MetricInfo oldInfo = this.metricMetricInfoMap.get(metric);
        if (oldInfo != null) {
            return this.metricRegistry.remove(oldInfo.getDropWizardMetricName());
        }
        return false;
    }

    @Override
    public boolean remove(String name, Map<String, String> tags) {
        String metricId = MetricInfo.builder().name(name).tags(tags).build().getMetricId();
        Metric metric = (Metric)this.metricRegistry.getMetrics().get(metricId);
        if (metric != null) {
            return this.metricMetricInfoMap.remove(metric) != null;
        }
        return false;
    }

    @Override
    public <T extends Metric> MetricInfo<T> metric(String name, Map<String, String> tags) {
        MetricInfo oldInfo = MetricInfo.builder().name(name).tags(tags).build();
        Metric oldMetric = (Metric)this.metricRegistry.getMetrics().get(oldInfo.getMetricId());
        if (oldMetric == null) {
            return null;
        }
        return this.metricMetricInfoMap.get(oldMetric);
    }

    @Override
    public List<MetricInfo> all() {
        return new ArrayList<MetricInfo>(this.metricMetricInfoMap.values());
    }

    @Override
    public <T extends Metric> MetricInfo<T> metric(T metric) {
        return this.metricMetricInfoMap.get(metric);
    }
}

