/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import io.partx.core.Config;
import io.partx.core.internal.ConfigImpl;
import io.partx.core.utils.Async;
import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    private ConfigRetriever configRetriever;
    private ConfigImpl config;

    ConfigService(Config config, Vertx vertx, ConfigRetrieverOptions retrieverOptions) {
        log.info("Initializing ConfigService");
        this.configRetriever = ConfigRetriever.create((Vertx)vertx, (ConfigRetrieverOptions)retrieverOptions);
        this.config = (ConfigImpl)config;
        this.configRetriever.listen((Handler)this.config);
        this.update();
    }

    void close() {
        log.info("Closing ConfigService");
        if (this.configRetriever != null) {
            this.configRetriever.close();
        }
    }

    void update() {
        AsyncResult result = Async.blocking(arg_0 -> ((ConfigRetriever)this.configRetriever).getConfig(arg_0));
        if (!result.succeeded()) {
            log.error("Failed to get config", result.cause());
            throw new IllegalStateException("Failed to get config", result.cause());
        }
        this.config.handle(new ConfigChange().setNewConfiguration((JsonObject)result.result()).setPreviousConfiguration(new JsonObject()));
    }
}

