/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.partx.core.Config;
import io.partx.core.Event;
import io.partx.core.Metadata;
import io.partx.core.Particle;
import io.partx.core.annotation.Listener;
import io.partx.core.annotation.Property;
import io.partx.core.annotation.Route;
import io.partx.core.internal.ModuleContext;
import io.partx.core.internal.ParticleImpl;
import io.partx.core.internal.RouteHandler;
import io.partx.core.metric.Metrics;
import io.partx.core.vertx.HttpStats;
import io.prometheus.client.vertx.MetricsHandler;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpService
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    @Inject
    private HttpServer httpServer;
    @Inject
    private Particle particle;
    @Property(value="http.server.port", env="HTTP_PORT", defaultValue="8080")
    private int httpPort;
    @Property(value="http.server.ip", env="HTTP_IP", defaultValue="localhost")
    private String httpIp;
    @Property(value="http.server.ssl", env="HTTPS_ENABLED", defaultValue="true")
    private boolean ssl;
    @Inject
    private Vertx vertx;
    @Inject
    private Metrics metrics;
    @Inject
    private ErrorHandler errorHandler;
    @Inject
    private HttpStats httpStats;

    @Route(value="/admin/modules")
    public ModuleContext getFacets() {
        return ((ParticleImpl)this.particle).getModule();
    }

    @Route(value="/admin/version")
    public Metadata getVersion() {
        return this.particle.metadata();
    }

    @Route(value="/admin/configs")
    public JsonObject getConfig() {
        return this.particle.get(Config.class).json();
    }

    @Route(value="/admin/configs/.+", regexp=true)
    public Object getConfig(RoutingContext routingContext) {
        String name = routingContext.request().path().substring("/admin/configs/".length()).replace("/", ".");
        return this.particle.get(Config.class).get(name).orElse(null);
    }

    @Route(value="/admin/metrics", method={HttpMethod.GET})
    public MetricsHandler getMetrics() {
        return new MetricsHandler();
    }

    @Listener(value={Event.Type.Start}, order=0x7FFFFFFF)
    public void deploy() {
        this.vertx.deployVerticle((Verticle)this, event -> {
            if (event.succeeded()) {
                log.info("Deployed HttpService {} in {} ms", event.result(), (Object)this.particle.metadata().getLiveTimeMs());
            } else {
                log.error("Failed to deploy HttpService", event.cause());
                this.particle.fail(event.cause());
            }
        });
    }

    private Router router(Particle particle) {
        ModuleContext context = ((ParticleImpl)particle).getModule();
        Router router = Router.router((Vertx)((Vertx)context.getInjector().getInstance(Vertx.class)));
        Ordering.from(Comparator.comparingInt(RouteHandler::getOrder)).sortedCopy(context.getRegistry().get(RouteHandler.class)).forEach(routeHandler -> routeHandler.register(router));
        router.errorHandler(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (Handler)((ErrorHandler)event -> {
            if (event.failed()) {
                this.httpStats.markError();
                log.error("Unexpected exception {} {} {} {}", new Object[]{event.request().method(), event.request().absoluteURI(), event.response().getStatusCode(), event.response().getStatusMessage(), event.failure()});
                if (!event.response().ended()) {
                    this.errorHandler.handle(event);
                }
            }
        }));
        log.info("Bind {} http routes", (Object)router.getRoutes().size());
        return router;
    }

    public void start(Future<Void> future) {
        this.metrics.metric(this.httpStats.getErrorCounter(), (Map<String, String>)ImmutableMap.of((Object)"ip", (Object)this.httpIp, (Object)"port", (Object)String.valueOf(this.httpPort)));
        Promise promise = Promise.promise();
        future.setHandler((Handler)promise);
        Router router = this.router(this.particle);
        log.info("Http server listening on {}:{}", (Object)this.httpIp, (Object)this.httpPort);
        this.httpServer.requestHandler((Handler)router).exceptionHandler(arg_0 -> ((Promise)promise).fail(arg_0)).listen(this.httpPort, this.httpIp, event -> {
            if (event.failed()) {
                this.httpStats.setUp(false);
                log.error("Http server failed to start ({}:{})", new Object[]{this.httpIp, this.httpPort, event.cause()});
                promise.fail(event.cause());
            } else {
                this.httpStats.setUp(true);
                log.info("Http server is ready ({}:{})", (Object)this.httpIp, (Object)this.httpPort);
                promise.complete();
            }
        });
    }

    @Listener(value={Event.Type.Shutdown}, order=0x7FFFFFFF)
    public void stop() {
        if (this.httpStats.getUp().get()) {
            this.httpServer.close(event -> {
                if (event.failed()) {
                    log.error("Failed to stop HttpServer on port {}", (Object)this.httpServer.actualPort(), (Object)event.cause());
                } else {
                    log.info("Stopped HttpServer on port {}", (Object)this.httpServer.actualPort());
                }
                this.httpStats.setUp(false);
            });
        }
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getHttpIp() {
        return this.httpIp;
    }

    public boolean isSsl() {
        return this.ssl;
    }
}

