/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.partx.core.annotation.Metric;
import io.partx.core.annotation.Route;
import io.partx.core.metric.Metrics;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpStats {
    private static final String REQ_START_TIME_KEY = "__request_start_time";
    private static final String REQ_TIME_METRIC = "http.request.time";
    private static final String REQ_STATS_METRIC = "http.request.stats";
    @Inject
    private Metrics metrics;
    @Metric(value="http.service.up")
    private final AtomicBoolean up = new AtomicBoolean(false);
    @Metric(value="http.error.count")
    private Counter errorCounter = new Counter();

    @Route(order=-2147483648)
    public void preRequest(RoutingContext routingContext) {
        routingContext.put(REQ_START_TIME_KEY, (Object)System.currentTimeMillis());
        routingContext.next();
    }

    @Route(order=0x7FFFFFFF)
    public void afterResponse(RoutingContext routingContext) {
        long latencyMs = System.currentTimeMillis() - (Long)routingContext.get(REQ_START_TIME_KEY);
        this.metrics.metric(() -> new Histogram((Reservoir)new ExponentiallyDecayingReservoir()), REQ_TIME_METRIC).update(latencyMs);
        this.metrics.metric(Counter::new, REQ_STATS_METRIC, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)routingContext.request().path(), (Object)"method", (Object)routingContext.request().rawMethod(), (Object)"status", (Object)String.valueOf(routingContext.response().getStatusCode()))).inc();
        if (!routingContext.response().ended()) {
            routingContext.next();
        }
    }

    public void setUp(boolean up) {
        this.up.set(up);
    }

    public void markError() {
        this.errorCounter.inc();
    }

    public AtomicBoolean getUp() {
        return this.up;
    }

    public Counter getErrorCounter() {
        return this.errorCounter;
    }
}

