/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.beans.ConstructorProperties;

public class Response {
    private HttpResponseStatus status;
    private Object data;

    public static Response ok() {
        return Response.builder().status(HttpResponseStatus.OK).build();
    }

    public static Response ok(String body) {
        return Response.builder().status(HttpResponseStatus.OK).data(body).build();
    }

    public static <T> Response ok(T body) {
        return Response.builder().status(HttpResponseStatus.OK).data(body).build();
    }

    public static Response of(HttpResponseStatus status) {
        return Response.builder().status(status).build();
    }

    public static <T> Response of(HttpResponseStatus status, T body) {
        return Response.builder().status(status).data(body).build();
    }

    public static ResponseBuilder builder() {
        return new ResponseBuilder();
    }

    @ConstructorProperties(value={"status", "data"})
    public Response(HttpResponseStatus status, Object data) {
        this.status = status;
        this.data = data;
    }

    public Response() {
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static class ResponseBuilder {
        private HttpResponseStatus status;
        private Object data;

        ResponseBuilder() {
        }

        public ResponseBuilder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public ResponseBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public Response build() {
            return new Response(this.status, this.data);
        }

        public String toString() {
            return "Response.ResponseBuilder(status=" + this.status + ", data=" + this.data + ")";
        }
    }
}

