/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.prometheus.client.vertx.MetricsHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.LinkedList;
import java.util.List;

public class VertxWebBundle
extends AbstractModule {
    private String faviconPath;
    private long faviconMaxAgeSeconds;
    private String bodyUploadDirectory;
    private String errorTemplate;
    private boolean enableErrorDetails;
    private final List<Runnable> lazyBinding = new LinkedList<Runnable>();
    private StaticHandler staticHandler;
    private String staticRoot;

    public <T extends Handler<RoutingContext>> VertxWebBundle bind(Class<T> type, Provider<T> provider) {
        if (provider != null) {
            this.lazyBinding.add(() -> this.bind(type).toProvider(provider).in(Singleton.class));
        }
        return this;
    }

    public <T extends Handler<RoutingContext>> VertxWebBundle bind(Class<T> type, T instance) {
        if (instance != null) {
            this.lazyBinding.add(() -> this.bind(type).toInstance((Object)instance));
        }
        return this;
    }

    protected void configure() {
        this.bind(ChainAuthHandler.class, ChainAuthHandler.create());
        this.bind((Class)MetricsHandler.class, (Handler)((Provider)MetricsHandler::new));
        this.bind((Class)BodyHandler.class, (Handler)((Provider)() -> {
            if (this.bodyUploadDirectory != null) {
                return BodyHandler.create((String)this.bodyUploadDirectory);
            }
            return BodyHandler.create();
        }));
        this.bind((Class)ErrorHandler.class, (Handler)((Provider)() -> this.errorTemplate != null ? ErrorHandler.create((String)this.errorTemplate, (boolean)this.enableErrorDetails) : ErrorHandler.create((boolean)this.enableErrorDetails)));
        this.bind((Class)FaviconHandler.class, (Handler)((Provider)() -> {
            if (this.faviconPath != null && this.faviconMaxAgeSeconds > 0L) {
                return FaviconHandler.create((String)this.faviconPath, (long)this.faviconMaxAgeSeconds);
            }
            if (this.faviconPath != null) {
                return FaviconHandler.create((String)this.faviconPath);
            }
            if (this.faviconMaxAgeSeconds > 0L) {
                return FaviconHandler.create((long)this.faviconMaxAgeSeconds);
            }
            return FaviconHandler.create();
        }));
        if (this.staticHandler == null) {
            this.staticHandler = StaticHandler.create();
        }
        if (this.staticRoot == null) {
            this.staticRoot = System.getProperty("vertx.static.webRoot");
            if (this.staticRoot != null && this.staticRoot.startsWith("/")) {
                this.staticHandler.setAllowRootFileSystemAccess(true);
            }
        }
        if (System.getProperty("vertx.static.cachingEnabled") != null) {
            this.staticHandler.setCachingEnabled(Boolean.parseBoolean(System.getProperty("vertx.static.cachingEnabled")));
        }
        if (this.staticRoot != null) {
            this.staticHandler.setWebRoot(this.staticRoot);
        }
        this.bind(StaticHandler.class, this.staticHandler);
        this.lazyBinding.forEach(Runnable::run);
    }

    public VertxWebBundle setFaviconPath(String faviconPath) {
        this.faviconPath = faviconPath;
        return this;
    }

    public VertxWebBundle setFaviconMaxAgeSeconds(long faviconMaxAgeSeconds) {
        this.faviconMaxAgeSeconds = faviconMaxAgeSeconds;
        return this;
    }

    public VertxWebBundle setBodyUploadDirectory(String bodyUploadDirectory) {
        this.bodyUploadDirectory = bodyUploadDirectory;
        return this;
    }

    public VertxWebBundle setErrorTemplate(String errorTemplate) {
        this.errorTemplate = errorTemplate;
        return this;
    }

    public VertxWebBundle setEnableErrorDetails(boolean enableErrorDetails) {
        this.enableErrorDetails = enableErrorDetails;
        return this;
    }

    public VertxWebBundle setStaticHandler(StaticHandler staticHandler) {
        this.staticHandler = staticHandler;
        return this;
    }

    public VertxWebBundle setStaticRoot(String staticRoot) {
        this.staticRoot = staticRoot;
        return this;
    }
}

