/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.parser.DefaultJsonWebTokenParser;
import com.google.common.hash.Hashing;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.ranger.RangerTarget;
import feign.slf4j.Slf4jLogger;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.auth.filter.PrimerAuthAnnotationFilter;
import io.dropwizard.primer.auth.filter.PrimerAuthConfigFilter;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.exception.PrimerExceptionMapper;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.dropwizard.primer.model.PrimerRangerEndpoint;
import io.dropwizard.primer.model.PrimerSimpleEndpoint;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.http.Consts;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrimerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(PrimerBundle.class);
    private static PrimerClient primerClient = null;
    private PrimerConfigurationHolder configHolder;

    public abstract PrimerBundleConfiguration getPrimerConfiguration(T var1);

    public abstract Set<String> withWhiteList(T var1);

    public abstract PrimerAuthorizationMatrix withAuthorization(T var1);

    public abstract PrimerAnnotationAuthorizer authorizer();

    public abstract String getPrimerConfigAttribute();

    public static PrimerClient getPrimerClient() {
        return primerClient;
    }

    public CuratorFramework getCurator(T configuration) {
        PrimerBundleConfiguration primerBundleConfiguration = this.getPrimerConfiguration(configuration);
        PrimerRangerEndpoint config = (PrimerRangerEndpoint)primerBundleConfiguration.getEndpoint();
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(config.getZookeeper()).namespace(config.getNamespace()).retryPolicy((RetryPolicy)new RetryNTimes(1000, 500)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(PrimerSimpleEndpoint.class, "simple")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(PrimerRangerEndpoint.class, "ranger")});
    }

    public void run(T configuration, final Environment environment) {
        PrimerBundleConfiguration primerConfig = this.getPrimerConfiguration(configuration);
        this.configHolder = new PrimerConfigurationHolder(primerConfig);
        this.initializeAuthorization(configuration);
        PrimerAuthorizationRegistry.initCache(this.configHolder.getConfig());
        final JacksonDecoder decoder = new JacksonDecoder();
        final JacksonEncoder encoder = new JacksonEncoder();
        final Slf4jLogger logger = new Slf4jLogger();
        final int clientConnectionPool = configuration.getServerFactory() instanceof DefaultServerFactory ? ((DefaultServerFactory)configuration.getServerFactory()).getMaxThreads() : 128;
        environment.lifecycle().manage(new Managed((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void start() {
                SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).build();
                ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                connectionManager.setDefaultMaxPerRoute(clientConnectionPool);
                connectionManager.setMaxTotal(clientConnectionPool);
                connectionManager.setDefaultMaxPerRoute(clientConnectionPool);
                connectionManager.setValidateAfterInactivity(30000);
                connectionManager.setDefaultSocketConfig(socketConfig);
                connectionManager.setDefaultConnectionConfig(connectionConfig);
                RequestConfig defaultRequestConfig = RequestConfig.custom().setAuthenticationEnabled(false).setRedirectsEnabled(false).setConnectTimeout(Integer.MAX_VALUE).setConnectionRequestTimeout(Integer.MAX_VALUE).build();
                HttpClientBuilder client = HttpClients.custom().addInterceptorFirst((httpRequest, httpContext) -> httpRequest.removeHeaders("Content-Length")).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig);
                primerClient = (PrimerClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).errorDecoder((methodKey, response) -> {
                    try {
                        PrimerError error = (PrimerError)environment.getObjectMapper().readValue(response.body().asInputStream(), PrimerError.class);
                        return PrimerException.builder().message(error.getMessage()).errorCode(error.getErrorCode()).status(response.status()).build();
                    }
                    catch (IOException e) {
                        return PrimerException.builder().status(response.status()).errorCode("PR000").message(e.getMessage()).build();
                    }
                }).client((Client)new ApacheHttpClient((HttpClient)client.build())).logger((feign.Logger)logger).logLevel(Logger.Level.BASIC).target(PrimerBundle.this.getPrimerTarget(this.val$configuration, environment));
            }

            public void stop() {
            }
        });
        environment.jersey().register((Object)new PrimerExceptionMapper());
        SecretKeySpec secretKeySpec = new SecretKeySpec(Hashing.murmur3_128().hashString((CharSequence)this.configHolder.getConfig().getPrivateKey(), StandardCharsets.UTF_8).asBytes(), "AES");
        GCMParameterSpec ivParameterSpec = new GCMParameterSpec(128, Arrays.copyOf(this.configHolder.getConfig().getPrivateKey().getBytes(), 8));
        environment.jersey().register((Object)PrimerAuthConfigFilter.builder().configHolder(this.configHolder).objectMapper(environment.getObjectMapper()).secretKeySpec(secretKeySpec).ivParameterSpec(ivParameterSpec).build());
        environment.jersey().register((Object)PrimerAuthAnnotationFilter.builder().configHolder(this.configHolder).objectMapper(environment.getObjectMapper()).authorizer(this.authorizer()).build());
    }

    private Target<PrimerClient> getPrimerTarget(T configuration, Environment environment) {
        PrimerBundleConfiguration primerConfig = this.getPrimerConfiguration(configuration);
        switch (primerConfig.getEndpoint().getType()) {
            case "simple": {
                PrimerSimpleEndpoint endpoint = (PrimerSimpleEndpoint)primerConfig.getEndpoint();
                return new Target.HardCodedTarget(PrimerClient.class, String.format("http://%s:%d", endpoint.getHost(), endpoint.getPort()));
            }
            case "ranger": {
                PrimerRangerEndpoint config = (PrimerRangerEndpoint)primerConfig.getEndpoint();
                try {
                    return new RangerTarget(PrimerClient.class, config.getEnvironment(), config.getNamespace(), config.getService(), this.getCurator(configuration), false, environment.getObjectMapper());
                }
                catch (Exception e) {
                    log.error("Error creating ranger endpoint for primer", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("unknown primer target type specified");
    }

    public void initializeAuthorization(T configuration) {
        PrimerAuthorizationMatrix permissionMatrix;
        DefaultJsonWebTokenParser tokenParser = new DefaultJsonWebTokenParser();
        PrimerBundleConfiguration primerConfig = this.configHolder.getConfig();
        byte[] secretKey = primerConfig.getPrivateKey().getBytes(StandardCharsets.UTF_8);
        HmacSHA512Verifier tokenVerifier = new HmacSHA512Verifier(secretKey);
        HashSet<String> whiteListUrls = new HashSet<String>();
        Set<String> dynamicWhiteList = this.withWhiteList(configuration);
        if (dynamicWhiteList != null) {
            whiteListUrls.addAll(dynamicWhiteList);
        }
        if (primerConfig.getWhileListUrl() != null) {
            whiteListUrls.addAll(primerConfig.getWhileListUrl());
        }
        if ((permissionMatrix = primerConfig.getAuthorizations()) == null) {
            permissionMatrix = this.withAuthorization(configuration);
        } else {
            PrimerAuthorizationMatrix dynamicAuthMatrix = this.withAuthorization(configuration);
            if (permissionMatrix.getAuthorizations() == null) {
                permissionMatrix.setAuthorizations(dynamicAuthMatrix.getAuthorizations());
            } else {
                permissionMatrix.getAuthorizations().addAll(dynamicAuthMatrix.getAuthorizations());
            }
            if (permissionMatrix.getAutoAuthorizations() == null) {
                permissionMatrix.setAutoAuthorizations(dynamicAuthMatrix.getAutoAuthorizations());
            } else {
                permissionMatrix.getAutoAuthorizations().addAll(dynamicAuthMatrix.getAutoAuthorizations());
            }
            if (permissionMatrix.getStaticAuthorizations() == null) {
                permissionMatrix.setStaticAuthorizations(dynamicAuthMatrix.getStaticAuthorizations());
            } else {
                permissionMatrix.getStaticAuthorizations().addAll(dynamicAuthMatrix.getStaticAuthorizations());
            }
        }
        PrimerAuthorizationRegistry.init(permissionMatrix, whiteListUrls, primerConfig, (JsonWebTokenParser)tokenParser, tokenVerifier);
    }

    public PrimerConfigurationHolder getConfigHolder() {
        return this.configHolder;
    }
}

