/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.config;

import io.phonepe.hystrixoptimizer.metrics.LatencyMetric;
import java.util.EnumSet;
import java.util.Set;

public class OptimizerTimeConfig {
    private boolean enabled;
    private Set<LatencyMetric> latencyMetrics = EnumSet.allOf(LatencyMetric.class);
    private LatencyMetric timeoutMetric;
    private double allMethodTimeoutBuffer;
    private LatencyMetric appLatencyMetric;
    private LatencyMetric apiLatencyMetric;
    private int appLatencyThresholdValue;

    public static OptimizerTimeConfigBuilder builder() {
        return new OptimizerTimeConfigBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<LatencyMetric> getLatencyMetrics() {
        return this.latencyMetrics;
    }

    public LatencyMetric getTimeoutMetric() {
        return this.timeoutMetric;
    }

    public double getAllMethodTimeoutBuffer() {
        return this.allMethodTimeoutBuffer;
    }

    public LatencyMetric getAppLatencyMetric() {
        return this.appLatencyMetric;
    }

    public LatencyMetric getApiLatencyMetric() {
        return this.apiLatencyMetric;
    }

    public int getAppLatencyThresholdValue() {
        return this.appLatencyThresholdValue;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLatencyMetrics(Set<LatencyMetric> latencyMetrics) {
        this.latencyMetrics = latencyMetrics;
    }

    public void setTimeoutMetric(LatencyMetric timeoutMetric) {
        this.timeoutMetric = timeoutMetric;
    }

    public void setAllMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
    }

    public void setAppLatencyMetric(LatencyMetric appLatencyMetric) {
        this.appLatencyMetric = appLatencyMetric;
    }

    public void setApiLatencyMetric(LatencyMetric apiLatencyMetric) {
        this.apiLatencyMetric = apiLatencyMetric;
    }

    public void setAppLatencyThresholdValue(int appLatencyThresholdValue) {
        this.appLatencyThresholdValue = appLatencyThresholdValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerTimeConfig)) {
            return false;
        }
        OptimizerTimeConfig other = (OptimizerTimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Set<LatencyMetric> this$latencyMetrics = this.getLatencyMetrics();
        Set<LatencyMetric> other$latencyMetrics = other.getLatencyMetrics();
        if (this$latencyMetrics == null ? other$latencyMetrics != null : !((Object)this$latencyMetrics).equals(other$latencyMetrics)) {
            return false;
        }
        LatencyMetric this$timeoutMetric = this.getTimeoutMetric();
        LatencyMetric other$timeoutMetric = other.getTimeoutMetric();
        if (this$timeoutMetric == null ? other$timeoutMetric != null : !((Object)((Object)this$timeoutMetric)).equals((Object)other$timeoutMetric)) {
            return false;
        }
        if (Double.compare(this.getAllMethodTimeoutBuffer(), other.getAllMethodTimeoutBuffer()) != 0) {
            return false;
        }
        LatencyMetric this$appLatencyMetric = this.getAppLatencyMetric();
        LatencyMetric other$appLatencyMetric = other.getAppLatencyMetric();
        if (this$appLatencyMetric == null ? other$appLatencyMetric != null : !((Object)((Object)this$appLatencyMetric)).equals((Object)other$appLatencyMetric)) {
            return false;
        }
        LatencyMetric this$apiLatencyMetric = this.getApiLatencyMetric();
        LatencyMetric other$apiLatencyMetric = other.getApiLatencyMetric();
        if (this$apiLatencyMetric == null ? other$apiLatencyMetric != null : !((Object)((Object)this$apiLatencyMetric)).equals((Object)other$apiLatencyMetric)) {
            return false;
        }
        return this.getAppLatencyThresholdValue() == other.getAppLatencyThresholdValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerTimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Set<LatencyMetric> $latencyMetrics = this.getLatencyMetrics();
        result = result * 59 + ($latencyMetrics == null ? 43 : ((Object)$latencyMetrics).hashCode());
        LatencyMetric $timeoutMetric = this.getTimeoutMetric();
        result = result * 59 + ($timeoutMetric == null ? 43 : ((Object)((Object)$timeoutMetric)).hashCode());
        long $allMethodTimeoutBuffer = Double.doubleToLongBits(this.getAllMethodTimeoutBuffer());
        result = result * 59 + (int)($allMethodTimeoutBuffer >>> 32 ^ $allMethodTimeoutBuffer);
        LatencyMetric $appLatencyMetric = this.getAppLatencyMetric();
        result = result * 59 + ($appLatencyMetric == null ? 43 : ((Object)((Object)$appLatencyMetric)).hashCode());
        LatencyMetric $apiLatencyMetric = this.getApiLatencyMetric();
        result = result * 59 + ($apiLatencyMetric == null ? 43 : ((Object)((Object)$apiLatencyMetric)).hashCode());
        result = result * 59 + this.getAppLatencyThresholdValue();
        return result;
    }

    public String toString() {
        return "OptimizerTimeConfig(enabled=" + this.isEnabled() + ", latencyMetrics=" + this.getLatencyMetrics() + ", timeoutMetric=" + (Object)((Object)this.getTimeoutMetric()) + ", allMethodTimeoutBuffer=" + this.getAllMethodTimeoutBuffer() + ", appLatencyMetric=" + (Object)((Object)this.getAppLatencyMetric()) + ", apiLatencyMetric=" + (Object)((Object)this.getApiLatencyMetric()) + ", appLatencyThresholdValue=" + this.getAppLatencyThresholdValue() + ")";
    }

    public OptimizerTimeConfig(boolean enabled, Set<LatencyMetric> latencyMetrics, LatencyMetric timeoutMetric, double allMethodTimeoutBuffer, LatencyMetric appLatencyMetric, LatencyMetric apiLatencyMetric, int appLatencyThresholdValue) {
        this.enabled = enabled;
        this.latencyMetrics = latencyMetrics;
        this.timeoutMetric = timeoutMetric;
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
        this.appLatencyMetric = appLatencyMetric;
        this.apiLatencyMetric = apiLatencyMetric;
        this.appLatencyThresholdValue = appLatencyThresholdValue;
    }

    public OptimizerTimeConfig() {
    }

    public static class OptimizerTimeConfigBuilder {
        private boolean enabled;
        private Set<LatencyMetric> latencyMetrics;
        private LatencyMetric timeoutMetric;
        private double allMethodTimeoutBuffer;
        private LatencyMetric appLatencyMetric;
        private LatencyMetric apiLatencyMetric;
        private int appLatencyThresholdValue;

        OptimizerTimeConfigBuilder() {
        }

        public OptimizerTimeConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OptimizerTimeConfigBuilder latencyMetrics(Set<LatencyMetric> latencyMetrics) {
            this.latencyMetrics = latencyMetrics;
            return this;
        }

        public OptimizerTimeConfigBuilder timeoutMetric(LatencyMetric timeoutMetric) {
            this.timeoutMetric = timeoutMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder allMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
            this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
            return this;
        }

        public OptimizerTimeConfigBuilder appLatencyMetric(LatencyMetric appLatencyMetric) {
            this.appLatencyMetric = appLatencyMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder apiLatencyMetric(LatencyMetric apiLatencyMetric) {
            this.apiLatencyMetric = apiLatencyMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder appLatencyThresholdValue(int appLatencyThresholdValue) {
            this.appLatencyThresholdValue = appLatencyThresholdValue;
            return this;
        }

        public OptimizerTimeConfig build() {
            return new OptimizerTimeConfig(this.enabled, this.latencyMetrics, this.timeoutMetric, this.allMethodTimeoutBuffer, this.appLatencyMetric, this.apiLatencyMetric, this.appLatencyThresholdValue);
        }

        public String toString() {
            return "OptimizerTimeConfig.OptimizerTimeConfigBuilder(enabled=" + this.enabled + ", latencyMetrics=" + this.latencyMetrics + ", timeoutMetric=" + (Object)((Object)this.timeoutMetric) + ", allMethodTimeoutBuffer=" + this.allMethodTimeoutBuffer + ", appLatencyMetric=" + (Object)((Object)this.appLatencyMetric) + ", apiLatencyMetric=" + (Object)((Object)this.apiLatencyMetric) + ", appLatencyThresholdValue=" + this.appLatencyThresholdValue + ")";
        }
    }
}

