/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.config.actions.impl;

import io.phonepe.hystrixoptimizer.config.actions.ActionConfig;
import io.phonepe.hystrixoptimizer.models.ActionType;
import io.phonepe.hystrixoptimizer.utils.ActionTypeVisitor;
import java.util.List;
import lombok.NonNull;
import org.hibernate.validator.constraints.NotEmpty;

public class EmailConfig
extends ActionConfig {
    @NonNull
    private String host;
    @NonNull
    private Integer port;
    @NonNull
    private String from;
    @NotEmpty
    private List<String> receivers;

    public EmailConfig(String host, Integer port, String from, List<String> receivers) {
        super(ActionType.SEND_EMAIL_ALERT);
        this.host = host;
        this.port = port;
        this.from = from;
        this.receivers = receivers;
    }

    @Override
    public <T> T accept(ActionTypeVisitor<T> actionTypeVisitor) {
        return actionTypeVisitor.visitSendEmailAlert(this);
    }

    public static EmailConfigBuilder builder() {
        return new EmailConfigBuilder();
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    @NonNull
    public Integer getPort() {
        return this.port;
    }

    @NonNull
    public String getFrom() {
        return this.from;
    }

    public List<String> getReceivers() {
        return this.receivers;
    }

    public void setHost(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host is marked @NonNull but is null");
        }
        this.host = host;
    }

    public void setPort(@NonNull Integer port) {
        if (port == null) {
            throw new NullPointerException("port is marked @NonNull but is null");
        }
        this.port = port;
    }

    public void setFrom(@NonNull String from) {
        if (from == null) {
            throw new NullPointerException("from is marked @NonNull but is null");
        }
        this.from = from;
    }

    public void setReceivers(List<String> receivers) {
        this.receivers = receivers;
    }

    @Override
    public String toString() {
        return "EmailConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", from=" + this.getFrom() + ", receivers=" + this.getReceivers() + ")";
    }

    public EmailConfig() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailConfig)) {
            return false;
        }
        EmailConfig other = (EmailConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        List<String> this$receivers = this.getReceivers();
        List<String> other$receivers = other.getReceivers();
        return !(this$receivers == null ? other$receivers != null : !((Object)this$receivers).equals(other$receivers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmailConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        List<String> $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : ((Object)$receivers).hashCode());
        return result;
    }

    public static class EmailConfigBuilder {
        private String host;
        private Integer port;
        private String from;
        private List<String> receivers;

        EmailConfigBuilder() {
        }

        public EmailConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public EmailConfigBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public EmailConfigBuilder from(String from) {
            this.from = from;
            return this;
        }

        public EmailConfigBuilder receivers(List<String> receivers) {
            this.receivers = receivers;
            return this;
        }

        public EmailConfig build() {
            return new EmailConfig(this.host, this.port, this.from, this.receivers);
        }

        public String toString() {
            return "EmailConfig.EmailConfigBuilder(host=" + this.host + ", port=" + this.port + ", from=" + this.from + ", receivers=" + this.receivers + ")";
        }
    }
}

