/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.core;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.phonepe.hystrixoptimizer.config.OptimizerConfig;
import io.phonepe.hystrixoptimizer.core.OptimizerCacheKey;
import io.phonepe.hystrixoptimizer.core.OptimizerMetricsCache;
import io.phonepe.hystrixoptimizer.metrics.LatencyMetric;
import io.phonepe.hystrixoptimizer.metrics.OptimizerMetricType;
import io.phonepe.hystrixoptimizer.metrics.ThreadPoolMetric;
import io.phonepe.hystrixoptimizer.models.OptimizerMetrics;
import java.util.Set;
import java.util.SortedMap;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsCollector
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsCollector.class);
    private MetricRegistry metrics;
    private OptimizerMetricsCache optimizerMetricsCache;
    private OptimizerConfig optimizerConfig;

    @Override
    public void run() {
        log.info("Running optimizer metrics collection job");
        SortedMap gauges = this.metrics.getGauges();
        Long time = new DateTime().getMillis();
        try {
            this.captureThreadPoolMetrics(gauges, time);
            this.captureLatencyMetrics(gauges, time);
        }
        catch (Exception e) {
            log.error("Error occurred while executing metrics collector : ", (Throwable)e);
        }
    }

    private void captureThreadPoolMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((key, gauge) -> this.updateOptimizerMetricsCache((String)key, (Gauge)gauge, time, 1, OptimizerMetricType.THREAD_POOL, ThreadPoolMetric.metrics()));
    }

    private void captureLatencyMetrics(SortedMap<String, Gauge> gauges, Long time) {
        gauges.forEach((key, gauge) -> this.updateOptimizerMetricsCache((String)key, (Gauge)gauge, time, 2, OptimizerMetricType.LATENCY, LatencyMetric.metrics()));
    }

    private void updateOptimizerMetricsCache(String key, Gauge gauge, long time, int keyStartIndex, OptimizerMetricType metricType, Set<String> metricsToCapture) {
        OptimizerMetrics optimizerMetrics;
        String[] splits = key.split("\\.");
        int length = splits.length;
        if (length < metricType.getMinValidLength()) {
            return;
        }
        String metricName = splits[length - 1];
        if (!metricsToCapture.contains(metricName) || !(gauge.getValue() instanceof Number)) {
            return;
        }
        OptimizerCacheKey cacheKey = this.getOptimizerCacheKey(time, splits, keyStartIndex, length, metricType);
        if (this.optimizerMetricsCache.get(cacheKey) == null) {
            this.optimizerMetricsCache.put(cacheKey, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
        }
        if ((optimizerMetrics = this.optimizerMetricsCache.get(cacheKey)) == null) {
            return;
        }
        optimizerMetrics.getMetrics().put(metricName, (Number)gauge.getValue());
    }

    private OptimizerCacheKey getOptimizerCacheKey(Long time, String[] splits, int keyStartIndex, int length, OptimizerMetricType metricType) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (int i = keyStartIndex; i < length - 1; ++i) {
            sb.append(delimiter);
            sb.append(splits[i]);
            delimiter = ".";
        }
        return new OptimizerCacheKey(time, sb.toString(), metricType);
    }

    public static OptimizerMetricsCollectorBuilder builder() {
        return new OptimizerMetricsCollectorBuilder();
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsCollector)) {
            return false;
        }
        OptimizerMetricsCollector other = (OptimizerMetricsCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        if (this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        return !(this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsCollector(metrics=" + this.getMetrics() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ", optimizerConfig=" + this.getOptimizerConfig() + ")";
    }

    public OptimizerMetricsCollector(MetricRegistry metrics, OptimizerMetricsCache optimizerMetricsCache, OptimizerConfig optimizerConfig) {
        this.metrics = metrics;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.optimizerConfig = optimizerConfig;
    }

    public static class OptimizerMetricsCollectorBuilder {
        private MetricRegistry metrics;
        private OptimizerMetricsCache optimizerMetricsCache;
        private OptimizerConfig optimizerConfig;

        OptimizerMetricsCollectorBuilder() {
        }

        public OptimizerMetricsCollectorBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public OptimizerMetricsCollector build() {
            return new OptimizerMetricsCollector(this.metrics, this.optimizerMetricsCache, this.optimizerConfig);
        }

        public String toString() {
            return "OptimizerMetricsCollector.OptimizerMetricsCollectorBuilder(metrics=" + this.metrics + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ", optimizerConfig=" + this.optimizerConfig + ")";
        }
    }
}

