/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import io.dropwizard.revolver.core.config.RevolverConfig;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RevolverConfigHolder {
    private AtomicReference<RevolverConfig> configReference;
    private final AtomicLong lastUpdatedTimestamp;

    public RevolverConfigHolder(RevolverConfig initialRevolverConfig) {
        this.configReference = new AtomicReference<RevolverConfig>(initialRevolverConfig);
        this.lastUpdatedTimestamp = new AtomicLong(System.currentTimeMillis());
    }

    public RevolverConfig getConfig() {
        return this.configReference.get();
    }

    public void setConfig(RevolverConfig config) {
        this.configReference.set(config);
        this.lastUpdatedTimestamp.set(System.currentTimeMillis());
    }
}

