/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverConfigHolder;
import io.dropwizard.revolver.core.config.resilience.ResilienceConfig;
import io.dropwizard.revolver.core.config.resilience.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.util.ResilienceUtil;
import io.dropwizard.setup.Environment;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ResilienceHttpContext
extends RevolverHttpContext {
    private static final String THREAD_POOL_PREFIX = "resilience";
    private CircuitBreaker defaultCircuitBreaker;
    private Map<String, CircuitBreaker> apiVsCircuitBreaker = Maps.newHashMap();
    private Map<String, Bulkhead> poolVsBulkHeadMap = Maps.newHashMap();
    private Map<String, Integer> apiVsTimeout = Maps.newHashMap();
    private ExecutorService executor;
    private MetricRegistry metrics;
    private RevolverConfigHolder revolverConfigHolder;

    public ResilienceHttpContext() {
        this.setupExecutor(new ResilienceConfig());
    }

    public void initialize(Environment environment, RevolverConfigHolder revolverConfigHolder, MetricRegistry metrics) {
        this.defaultCircuitBreaker = ResilienceUtil.circuitBreakerRegistry.circuitBreaker("revolver");
        this.metrics = metrics;
        this.revolverConfigHolder = revolverConfigHolder;
        this.setupExecutor(revolverConfigHolder.getConfig().getResilienceConfig());
        ResilienceUtil.bindResilienceMetrics(metrics);
        ResilienceUtil.initializeResilience(revolverConfigHolder.getConfig(), this);
    }

    public RevolverExecutorType getExecutorType() {
        return RevolverExecutorType.RESILIENCE;
    }

    public void reload(RevolverConfig revolverConfig) {
        this.setupExecutor(revolverConfig.getResilienceConfig());
        ResilienceUtil.initializeResilience(revolverConfig, this);
    }

    public ExecutorService getExecutor() {
        if (this.executor == null) {
            this.setupExecutor(this.revolverConfigHolder.getConfig() != null ? this.revolverConfigHolder.getConfig().getResilienceConfig() : new ResilienceConfig());
        }
        return this.executor;
    }

    private void setupExecutor(ResilienceConfig resilienceConfig) {
        if (null == resilienceConfig) {
            resilienceConfig = new ResilienceConfig();
        }
        ThreadPoolConfig threadPoolConfig = resilienceConfig.getThreadPoolConfig();
        NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_POOL_PREFIX);
        this.executor = new ThreadPoolExecutor(threadPoolConfig.getCorePoolSize(), threadPoolConfig.getMaxPoolSize(), (long)threadPoolConfig.getKeepAliveTimeInSeconds(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadPoolConfig.getQueueSize()), (ThreadFactory)threadFactory);
    }

    public static ResilienceHttpContextBuilder builder() {
        return new ResilienceHttpContextBuilder();
    }

    public CircuitBreaker getDefaultCircuitBreaker() {
        return this.defaultCircuitBreaker;
    }

    public Map<String, CircuitBreaker> getApiVsCircuitBreaker() {
        return this.apiVsCircuitBreaker;
    }

    public Map<String, Bulkhead> getPoolVsBulkHeadMap() {
        return this.poolVsBulkHeadMap;
    }

    public Map<String, Integer> getApiVsTimeout() {
        return this.apiVsTimeout;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public RevolverConfigHolder getRevolverConfigHolder() {
        return this.revolverConfigHolder;
    }

    public void setDefaultCircuitBreaker(CircuitBreaker defaultCircuitBreaker) {
        this.defaultCircuitBreaker = defaultCircuitBreaker;
    }

    public void setApiVsCircuitBreaker(Map<String, CircuitBreaker> apiVsCircuitBreaker) {
        this.apiVsCircuitBreaker = apiVsCircuitBreaker;
    }

    public void setPoolVsBulkHeadMap(Map<String, Bulkhead> poolVsBulkHeadMap) {
        this.poolVsBulkHeadMap = poolVsBulkHeadMap;
    }

    public void setApiVsTimeout(Map<String, Integer> apiVsTimeout) {
        this.apiVsTimeout = apiVsTimeout;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setRevolverConfigHolder(RevolverConfigHolder revolverConfigHolder) {
        this.revolverConfigHolder = revolverConfigHolder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResilienceHttpContext)) {
            return false;
        }
        ResilienceHttpContext other = (ResilienceHttpContext)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CircuitBreaker this$defaultCircuitBreaker = this.getDefaultCircuitBreaker();
        CircuitBreaker other$defaultCircuitBreaker = other.getDefaultCircuitBreaker();
        if (this$defaultCircuitBreaker == null ? other$defaultCircuitBreaker != null : !this$defaultCircuitBreaker.equals(other$defaultCircuitBreaker)) {
            return false;
        }
        Map<String, CircuitBreaker> this$apiVsCircuitBreaker = this.getApiVsCircuitBreaker();
        Map<String, CircuitBreaker> other$apiVsCircuitBreaker = other.getApiVsCircuitBreaker();
        if (this$apiVsCircuitBreaker == null ? other$apiVsCircuitBreaker != null : !((Object)this$apiVsCircuitBreaker).equals(other$apiVsCircuitBreaker)) {
            return false;
        }
        Map<String, Bulkhead> this$poolVsBulkHeadMap = this.getPoolVsBulkHeadMap();
        Map<String, Bulkhead> other$poolVsBulkHeadMap = other.getPoolVsBulkHeadMap();
        if (this$poolVsBulkHeadMap == null ? other$poolVsBulkHeadMap != null : !((Object)this$poolVsBulkHeadMap).equals(other$poolVsBulkHeadMap)) {
            return false;
        }
        Map<String, Integer> this$apiVsTimeout = this.getApiVsTimeout();
        Map<String, Integer> other$apiVsTimeout = other.getApiVsTimeout();
        if (this$apiVsTimeout == null ? other$apiVsTimeout != null : !((Object)this$apiVsTimeout).equals(other$apiVsTimeout)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        RevolverConfigHolder this$revolverConfigHolder = this.getRevolverConfigHolder();
        RevolverConfigHolder other$revolverConfigHolder = other.getRevolverConfigHolder();
        return !(this$revolverConfigHolder == null ? other$revolverConfigHolder != null : !this$revolverConfigHolder.equals(other$revolverConfigHolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResilienceHttpContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CircuitBreaker $defaultCircuitBreaker = this.getDefaultCircuitBreaker();
        result = result * 59 + ($defaultCircuitBreaker == null ? 43 : $defaultCircuitBreaker.hashCode());
        Map<String, CircuitBreaker> $apiVsCircuitBreaker = this.getApiVsCircuitBreaker();
        result = result * 59 + ($apiVsCircuitBreaker == null ? 43 : ((Object)$apiVsCircuitBreaker).hashCode());
        Map<String, Bulkhead> $poolVsBulkHeadMap = this.getPoolVsBulkHeadMap();
        result = result * 59 + ($poolVsBulkHeadMap == null ? 43 : ((Object)$poolVsBulkHeadMap).hashCode());
        Map<String, Integer> $apiVsTimeout = this.getApiVsTimeout();
        result = result * 59 + ($apiVsTimeout == null ? 43 : ((Object)$apiVsTimeout).hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        RevolverConfigHolder $revolverConfigHolder = this.getRevolverConfigHolder();
        result = result * 59 + ($revolverConfigHolder == null ? 43 : $revolverConfigHolder.hashCode());
        return result;
    }

    public String toString() {
        return "ResilienceHttpContext(defaultCircuitBreaker=" + this.getDefaultCircuitBreaker() + ", apiVsCircuitBreaker=" + this.getApiVsCircuitBreaker() + ", poolVsBulkHeadMap=" + this.getPoolVsBulkHeadMap() + ", apiVsTimeout=" + this.getApiVsTimeout() + ", executor=" + this.getExecutor() + ", metrics=" + this.getMetrics() + ", revolverConfigHolder=" + this.getRevolverConfigHolder() + ")";
    }

    public ResilienceHttpContext(CircuitBreaker defaultCircuitBreaker, Map<String, CircuitBreaker> apiVsCircuitBreaker, Map<String, Bulkhead> poolVsBulkHeadMap, Map<String, Integer> apiVsTimeout, ExecutorService executor, MetricRegistry metrics, RevolverConfigHolder revolverConfigHolder) {
        this.defaultCircuitBreaker = defaultCircuitBreaker;
        this.apiVsCircuitBreaker = apiVsCircuitBreaker;
        this.poolVsBulkHeadMap = poolVsBulkHeadMap;
        this.apiVsTimeout = apiVsTimeout;
        this.executor = executor;
        this.metrics = metrics;
        this.revolverConfigHolder = revolverConfigHolder;
    }

    public static class ResilienceHttpContextBuilder {
        private CircuitBreaker defaultCircuitBreaker;
        private Map<String, CircuitBreaker> apiVsCircuitBreaker;
        private Map<String, Bulkhead> poolVsBulkHeadMap;
        private Map<String, Integer> apiVsTimeout;
        private ExecutorService executor;
        private MetricRegistry metrics;
        private RevolverConfigHolder revolverConfigHolder;

        ResilienceHttpContextBuilder() {
        }

        public ResilienceHttpContextBuilder defaultCircuitBreaker(CircuitBreaker defaultCircuitBreaker) {
            this.defaultCircuitBreaker = defaultCircuitBreaker;
            return this;
        }

        public ResilienceHttpContextBuilder apiVsCircuitBreaker(Map<String, CircuitBreaker> apiVsCircuitBreaker) {
            this.apiVsCircuitBreaker = apiVsCircuitBreaker;
            return this;
        }

        public ResilienceHttpContextBuilder poolVsBulkHeadMap(Map<String, Bulkhead> poolVsBulkHeadMap) {
            this.poolVsBulkHeadMap = poolVsBulkHeadMap;
            return this;
        }

        public ResilienceHttpContextBuilder apiVsTimeout(Map<String, Integer> apiVsTimeout) {
            this.apiVsTimeout = apiVsTimeout;
            return this;
        }

        public ResilienceHttpContextBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ResilienceHttpContextBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public ResilienceHttpContextBuilder revolverConfigHolder(RevolverConfigHolder revolverConfigHolder) {
            this.revolverConfigHolder = revolverConfigHolder;
            return this;
        }

        public ResilienceHttpContext build() {
            return new ResilienceHttpContext(this.defaultCircuitBreaker, this.apiVsCircuitBreaker, this.poolVsBulkHeadMap, this.apiVsTimeout, this.executor, this.metrics, this.revolverConfigHolder);
        }

        public String toString() {
            return "ResilienceHttpContext.ResilienceHttpContextBuilder(defaultCircuitBreaker=" + this.defaultCircuitBreaker + ", apiVsCircuitBreaker=" + this.apiVsCircuitBreaker + ", poolVsBulkHeadMap=" + this.poolVsBulkHeadMap + ", apiVsTimeout=" + this.apiVsTimeout + ", executor=" + this.executor + ", metrics=" + this.metrics + ", revolverConfigHolder=" + this.revolverConfigHolder + ")";
        }
    }
}

