/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.confighandler;

import io.dropwizard.revolver.confighandler.ConfigLoadInfo;
import io.dropwizard.revolver.confighandler.ConfigUpdateEvent;
import io.dropwizard.revolver.util.CommonUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigUpdateEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigUpdateEventListener.class);
    private String configAttribute;
    private ConfigLoadInfo configLoadInfo;

    public ConfigUpdateEventListener(String configAttribute) {
        this.configAttribute = configAttribute;
        this.configLoadInfo = ConfigLoadInfo.builder().previousConfigHash("unknown").previousLoadTime(new Date()).build();
    }

    void configUpdated(ConfigUpdateEvent configUpdateEvent) {
        try {
            String configString = configUpdateEvent.getUpdatedConfig().get(this.configAttribute).toString();
            String currentConfigHash = CommonUtils.computeHash((String)configString);
            log.info("Old Config Hash for {} : {} | New Config Hash: {}", new Object[]{this.configAttribute, this.configLoadInfo.getPreviousConfigHash(), currentConfigHash});
            if (!this.configLoadInfo.getPreviousConfigHash().equals(currentConfigHash)) {
                this.reloadConfig(configString);
                this.configLoadInfo.setPreviousConfigHash(currentConfigHash);
                this.configLoadInfo.setPreviousLoadTime(new Date());
            }
        }
        catch (Exception e) {
            log.error("Error updating revolver configuration", (Throwable)e);
        }
    }

    protected abstract void reloadConfig(String var1);
}

