/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db.dao;

import io.raven.db.utils.Generics;
import java.util.List;
import java.util.Objects;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class AbstractDao<E> {
    private final SessionFactory sessionFactory;
    private final Class<?> entityClass;

    public AbstractDao(SessionFactory sessionFactory) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.entityClass = Generics.getTypeParameter(this.getClass());
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected E uniqueResult(Criteria criteria) {
        return (E)Objects.requireNonNull(criteria).uniqueResult();
    }

    protected List<E> list(Criteria criteria) {
        return Objects.requireNonNull(criteria).list();
    }

    protected Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected E persist(E entity) {
        if (this.currentSession().contains(entity)) {
            this.currentSession().refresh(entity);
        }
        this.currentSession().saveOrUpdate(Objects.requireNonNull(entity));
        return entity;
    }
}

