/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db.utils;

import com.google.common.base.Strings;
import io.raven.db.config.JanusConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryUtil.class);
    private SessionFactory sessionFactory;
    private final JanusConfig janusConfig;
    private final List<Class<?>> entities;

    private SessionFactoryUtil(JanusConfig janusConfig, List<Class<?>> entities) {
        this.janusConfig = janusConfig;
        this.entities = entities;
    }

    public static SessionFactoryUtil getInstance(JanusConfig janusConfig, List<Class<?>> entities) {
        return new SessionFactoryUtil(janusConfig, entities);
    }

    public synchronized SessionFactory getSessionFactory() {
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.hbm2ddl.auto", this.janusConfig.isCreateSchema() ? "create-drop" : "none");
        settings.put("hibernate.show_sql", this.janusConfig.isShowSql());
        settings.put("hibernate.current_session_context_class", "managed");
        settings.put("hibernate.dialect", this.janusConfig.getDialect());
        settings.put("hibernate.connection.url", this.janusConfig.getUrl());
        if (!Strings.isNullOrEmpty((String)this.janusConfig.getUser())) {
            settings.put("hibernate.connection.username", this.janusConfig.getUser());
        }
        if (!Strings.isNullOrEmpty((String)this.janusConfig.getPassword())) {
            settings.put("hibernate.connection.password", this.janusConfig.getPassword());
        }
        if (Objects.nonNull(this.janusConfig.getCatalog())) {
            settings.put("hibernate.default_catalog", this.janusConfig.getCatalog());
        }
        settings.put("hibernate.connection.schema", this.janusConfig.getDatabase());
        settings.put("hibernate.connection.driver_class", this.janusConfig.getDriverClass());
        settings.put("hibernate.hikari.connectionTimeout", "20000");
        settings.put("hibernate.hikari.minimumIdle", String.valueOf(this.janusConfig.getMinPoolSize()));
        settings.put("hibernate.hikari.maximumPoolSize", String.valueOf(this.janusConfig.getMaxPoolSize()));
        settings.put("hibernate.hikari.idleTimeout", String.valueOf(this.janusConfig.getIdleTimeout()));
        if (Objects.nonNull(this.janusConfig.getTestQuery())) {
            settings.put("hibernate.hikari.connectionTestQuery", this.janusConfig.getTestQuery());
        }
        settings.put("hibernate.hikari.autoCommit", "false");
        settings.put("hibernate.hikari.maxLifetime", String.valueOf(this.janusConfig.getMaxAge()));
        settings.put("hibernate.temp.use_jdbc_metadata_defaults", "false");
        settings.put("hibernate.cache.use_query_cache", "false");
        settings.put("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
        settings.put("hibernate.cache.use_minimal_puts", "false");
        settings.put("max_fetch_depth", "3");
        registryBuilder.applySettings(settings);
        StandardServiceRegistry registry = registryBuilder.build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)registry);
        this.entities.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
        Metadata metadata = sources.getMetadataBuilder().build();
        this.sessionFactory = metadata.getSessionFactoryBuilder().applyStatisticsSupport(false).build();
        return this.sessionFactory;
    }

    public void close() {
        this.sessionFactory.close();
    }
}

