/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.auth.jwt.JwtAuthBundle;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.annotation.JwtAuthParam;
import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import io.dropwizard.auth.jwt.config.JwtAuthBundleConfiguration;
import io.dropwizard.auth.jwt.core.JwtUser;
import io.dropwizard.auth.jwt.util.TokenUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;

public class JwtAuthDynamicFeature
implements DynamicFeature {
    private final JwtAuthorizer authorizer;
    private static JwtAuthBundleConfiguration configuration;
    private static LoadingCache<String, JwtUser> tokenCache;

    public JwtAuthDynamicFeature(JwtAuthBundleConfiguration configuration, JwtAuthorizer authorizer) {
        JwtAuthDynamicFeature.configuration = configuration;
        this.authorizer = authorizer;
        tokenCache = Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()).build(JwtAuthDynamicFeature::getUser);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null) {
            Stream.of(resourceMethod.getParameterAnnotations()).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JwtAuthRequired.class)).map(JwtAuthRequired.class::cast).findFirst().ifPresent(authRequired -> {
                FeatureContext cfr_ignored_0 = (FeatureContext)featureContext.register((Object)this.getAuthFilter((JwtAuthRequired)authRequired));
            });
        }
    }

    private static JwtUser getUser(String token) {
        try {
            return TokenUtils.verify(JwtAuthBundle.getKey(), token, configuration);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private ContainerRequestFilter getAuthFilter(JwtAuthRequired authRequired) {
        return containerRequestContext -> {
            JwtUser user;
            block8: {
                String authHeader = containerRequestContext.getHeaderString("Authorization");
                if (authHeader == null) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                String token = authHeader.startsWith("Bearer:") ? authHeader.replace("Bearer:", "").trim() : authHeader;
                try {
                    user = (JwtUser)tokenCache.get((Object)token);
                    boolean authorize = false;
                    for (String audience : authRequired.value()) {
                        if (!user.getClaims().getAudience().contains(audience)) continue;
                        authorize = true;
                        break;
                    }
                    if (authRequired.authParams() != null && authRequired.authParams().length > 0) {
                        for (JwtAuthParam param : authRequired.authParams()) {
                            if (!user.getClaims().hasClaim(param.name()) || !user.getClaims().isClaimValueOfType(param.name(), ArrayList.class) || !Collections.disjoint(Arrays.asList(param.value()), (Collection)user.getClaims().getClaimValue(param.name(), ArrayList.class))) continue;
                            authorize = false;
                            break;
                        }
                    }
                    if (authorize) {
                        if (this.authorizer != null && !this.authorizer.authorize(user.getClaims(), containerRequestContext)) {
                            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                        }
                        break block8;
                    }
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                catch (Exception e) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
            }
            containerRequestContext.setProperty("user", (Object)user);
        };
    }

    public static JwtAuthDynamicFeatureBuilder builder() {
        return new JwtAuthDynamicFeatureBuilder();
    }

    public static class JwtAuthDynamicFeatureBuilder {
        private JwtAuthBundleConfiguration configuration;
        private JwtAuthorizer authorizer;

        JwtAuthDynamicFeatureBuilder() {
        }

        public JwtAuthDynamicFeatureBuilder configuration(JwtAuthBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public JwtAuthDynamicFeatureBuilder authorizer(JwtAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public JwtAuthDynamicFeature build() {
            return new JwtAuthDynamicFeature(this.configuration, this.authorizer);
        }

        public String toString() {
            return "JwtAuthDynamicFeature.JwtAuthDynamicFeatureBuilder(configuration=" + this.configuration + ", authorizer=" + this.authorizer + ")";
        }
    }
}

