/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.config;

public class JwtAuthBundleConfiguration {
    private String key;
    private int cacheExpiry;
    private int cacheMaxSize;
    private int clockSkew;
    private String authHeader;

    private static int $default$cacheExpiry() {
        return 3600;
    }

    private static int $default$cacheMaxSize() {
        return 1000;
    }

    private static int $default$clockSkew() {
        return 30;
    }

    private static String $default$authHeader() {
        return "Authorization";
    }

    public static JwtAuthBundleConfigurationBuilder builder() {
        return new JwtAuthBundleConfigurationBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setAuthHeader(String authHeader) {
        this.authHeader = authHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthBundleConfiguration)) {
            return false;
        }
        JwtAuthBundleConfiguration other = (JwtAuthBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCacheExpiry() != other.getCacheExpiry()) {
            return false;
        }
        if (this.getCacheMaxSize() != other.getCacheMaxSize()) {
            return false;
        }
        if (this.getClockSkew() != other.getClockSkew()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$authHeader = this.getAuthHeader();
        String other$authHeader = other.getAuthHeader();
        return !(this$authHeader == null ? other$authHeader != null : !this$authHeader.equals(other$authHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCacheExpiry();
        result = result * 59 + this.getCacheMaxSize();
        result = result * 59 + this.getClockSkew();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $authHeader = this.getAuthHeader();
        result = result * 59 + ($authHeader == null ? 43 : $authHeader.hashCode());
        return result;
    }

    public String toString() {
        return "JwtAuthBundleConfiguration(key=" + this.getKey() + ", cacheExpiry=" + this.getCacheExpiry() + ", cacheMaxSize=" + this.getCacheMaxSize() + ", clockSkew=" + this.getClockSkew() + ", authHeader=" + this.getAuthHeader() + ")";
    }

    public JwtAuthBundleConfiguration(String key, int cacheExpiry, int cacheMaxSize, int clockSkew, String authHeader) {
        this.key = key;
        this.cacheExpiry = cacheExpiry;
        this.cacheMaxSize = cacheMaxSize;
        this.clockSkew = clockSkew;
        this.authHeader = authHeader;
    }

    public JwtAuthBundleConfiguration() {
        this.cacheExpiry = JwtAuthBundleConfiguration.$default$cacheExpiry();
        this.cacheMaxSize = JwtAuthBundleConfiguration.$default$cacheMaxSize();
        this.clockSkew = JwtAuthBundleConfiguration.$default$clockSkew();
        this.authHeader = JwtAuthBundleConfiguration.$default$authHeader();
    }

    public static class JwtAuthBundleConfigurationBuilder {
        private String key;
        private boolean cacheExpiry$set;
        private int cacheExpiry$value;
        private boolean cacheMaxSize$set;
        private int cacheMaxSize$value;
        private boolean clockSkew$set;
        private int clockSkew$value;
        private boolean authHeader$set;
        private String authHeader$value;

        JwtAuthBundleConfigurationBuilder() {
        }

        public JwtAuthBundleConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry$value = cacheExpiry;
            this.cacheExpiry$set = true;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder cacheMaxSize(int cacheMaxSize) {
            this.cacheMaxSize$value = cacheMaxSize;
            this.cacheMaxSize$set = true;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew$value = clockSkew;
            this.clockSkew$set = true;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder authHeader(String authHeader) {
            this.authHeader$value = authHeader;
            this.authHeader$set = true;
            return this;
        }

        public JwtAuthBundleConfiguration build() {
            int cacheExpiry$value = this.cacheExpiry$value;
            if (!this.cacheExpiry$set) {
                cacheExpiry$value = JwtAuthBundleConfiguration.$default$cacheExpiry();
            }
            int cacheMaxSize$value = this.cacheMaxSize$value;
            if (!this.cacheMaxSize$set) {
                cacheMaxSize$value = JwtAuthBundleConfiguration.$default$cacheMaxSize();
            }
            int clockSkew$value = this.clockSkew$value;
            if (!this.clockSkew$set) {
                clockSkew$value = JwtAuthBundleConfiguration.$default$clockSkew();
            }
            String authHeader$value = this.authHeader$value;
            if (!this.authHeader$set) {
                authHeader$value = JwtAuthBundleConfiguration.$default$authHeader();
            }
            return new JwtAuthBundleConfiguration(this.key, cacheExpiry$value, cacheMaxSize$value, clockSkew$value, authHeader$value);
        }

        public String toString() {
            return "JwtAuthBundleConfiguration.JwtAuthBundleConfigurationBuilder(key=" + this.key + ", cacheExpiry$value=" + this.cacheExpiry$value + ", cacheMaxSize$value=" + this.cacheMaxSize$value + ", clockSkew$value=" + this.clockSkew$value + ", authHeader$value=" + this.authHeader$value + ")";
        }
    }
}

