/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.annotation.JwtAuthParam;
import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import io.dropwizard.auth.jwt.core.JwtUser;
import io.dropwizard.auth.jwt.util.TokenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthDynamicFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthDynamicFeature.class);
    public static final String AUTHORIZED_FOR_SUBJECT = "X-AUTHORIZED-FOR-SUBJECT";
    public static final String AUTHORIZED_FOR_MASK = "X-AUTHORIZED-FOR-%s";
    private final JwtAuthorizer authorizer;
    private final JwtConsumer jwtConsumer;
    private final LoadingCache<String, JwtUser> tokenCache;

    public JwtAuthDynamicFeature(JwtConsumer jwtConsumer, int cacheExpiry, int cacheSize, JwtAuthorizer authorizer) {
        this.jwtConsumer = jwtConsumer;
        this.authorizer = authorizer;
        this.tokenCache = Caffeine.newBuilder().expireAfterWrite((long)cacheExpiry, TimeUnit.SECONDS).maximumSize((long)cacheSize).build(this::getUser);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        JwtAuthRequired authRequired = resourceInfo.getResourceMethod().getAnnotation(JwtAuthRequired.class);
        if (Objects.nonNull(authRequired)) {
            context.register((Object)this.getAuthFilter(authRequired));
        }
    }

    private JwtUser getUser(String token) {
        try {
            return TokenUtils.verify(this.jwtConsumer, token);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private ContainerRequestFilter getAuthFilter(JwtAuthRequired authRequired) {
        return containerRequestContext -> {
            JwtUser user;
            block11: {
                String authHeader = containerRequestContext.getHeaderString("Authorization");
                if (authHeader == null) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                String token = authHeader.startsWith("Bearer:") ? authHeader.replace("Bearer:", "").trim() : authHeader;
                try {
                    user = (JwtUser)this.tokenCache.get((Object)token);
                    boolean authorize = false;
                    for (String audience : authRequired.value()) {
                        if (audience.equals("*")) {
                            authorize = true;
                            break;
                        }
                        if (!user.getClaims().getAudience().contains(audience)) continue;
                        authorize = true;
                        break;
                    }
                    if (authRequired.authParams() != null && authRequired.authParams().length > 0) {
                        for (JwtAuthParam param : authRequired.authParams()) {
                            if (!user.getClaims().hasClaim(param.name()) || !user.getClaims().isClaimValueOfType(param.name(), ArrayList.class) || !Collections.disjoint(Arrays.asList(param.value()), (Collection)user.getClaims().getClaimValue(param.name(), ArrayList.class))) continue;
                            authorize = false;
                            break;
                        }
                    }
                    if (authorize) {
                        if (this.authorizer != null && !this.authorizer.authorize(user.getClaims(), containerRequestContext)) {
                            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                        }
                        break block11;
                    }
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                catch (Exception e) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
            }
            containerRequestContext.setProperty("user", (Object)user);
            try {
                this.stampHeaders(containerRequestContext, user.getClaims());
            }
            catch (MalformedClaimException e) {
                log.error("Cannot stamp headers for user: {} | Error: {}", (Object)user.getName(), (Object)e);
            }
        };
    }

    public void stampHeaders(ContainerRequestContext requestContext, JwtClaims jwtClaims) throws MalformedClaimException {
        requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_SUBJECT, (Object)jwtClaims.getSubject());
        jwtClaims.flattenClaims().forEach((s, objects) -> requestContext.getHeaders().putSingle((Object)String.format(AUTHORIZED_FOR_MASK, s), (Object)String.valueOf(objects)));
    }

    public static JwtAuthDynamicFeatureBuilder builder() {
        return new JwtAuthDynamicFeatureBuilder();
    }

    public static class JwtAuthDynamicFeatureBuilder {
        private JwtConsumer jwtConsumer;
        private int cacheExpiry;
        private int cacheSize;
        private JwtAuthorizer authorizer;

        JwtAuthDynamicFeatureBuilder() {
        }

        public JwtAuthDynamicFeatureBuilder jwtConsumer(JwtConsumer jwtConsumer) {
            this.jwtConsumer = jwtConsumer;
            return this;
        }

        public JwtAuthDynamicFeatureBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        public JwtAuthDynamicFeatureBuilder cacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public JwtAuthDynamicFeatureBuilder authorizer(JwtAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public JwtAuthDynamicFeature build() {
            return new JwtAuthDynamicFeature(this.jwtConsumer, this.cacheExpiry, this.cacheSize, this.authorizer);
        }

        public String toString() {
            return "JwtAuthDynamicFeature.JwtAuthDynamicFeatureBuilder(jwtConsumer=" + this.jwtConsumer + ", cacheExpiry=" + this.cacheExpiry + ", cacheSize=" + this.cacheSize + ", authorizer=" + this.authorizer + ")";
        }
    }
}

