/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.config;

public class JwtAuthBundleConfiguration {
    private String key;
    private int cacheExpiry = 3600;
    private int cacheMaxSize = 1000;
    private int clockSkew = 30;

    public static JwtAuthBundleConfigurationBuilder builder() {
        return new JwtAuthBundleConfigurationBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthBundleConfiguration)) {
            return false;
        }
        JwtAuthBundleConfiguration other = (JwtAuthBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCacheExpiry() != other.getCacheExpiry()) {
            return false;
        }
        if (this.getCacheMaxSize() != other.getCacheMaxSize()) {
            return false;
        }
        if (this.getClockSkew() != other.getClockSkew()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCacheExpiry();
        result = result * 59 + this.getCacheMaxSize();
        result = result * 59 + this.getClockSkew();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "JwtAuthBundleConfiguration(key=" + this.getKey() + ", cacheExpiry=" + this.getCacheExpiry() + ", cacheMaxSize=" + this.getCacheMaxSize() + ", clockSkew=" + this.getClockSkew() + ")";
    }

    public JwtAuthBundleConfiguration(String key, int cacheExpiry, int cacheMaxSize, int clockSkew) {
        this.key = key;
        this.cacheExpiry = cacheExpiry;
        this.cacheMaxSize = cacheMaxSize;
        this.clockSkew = clockSkew;
    }

    public JwtAuthBundleConfiguration() {
    }

    public static class JwtAuthBundleConfigurationBuilder {
        private String key;
        private int cacheExpiry;
        private int cacheMaxSize;
        private int clockSkew;

        JwtAuthBundleConfigurationBuilder() {
        }

        public JwtAuthBundleConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder cacheMaxSize(int cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public JwtAuthBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public JwtAuthBundleConfiguration build() {
            return new JwtAuthBundleConfiguration(this.key, this.cacheExpiry, this.cacheMaxSize, this.clockSkew);
        }

        public String toString() {
            return "JwtAuthBundleConfiguration.JwtAuthBundleConfigurationBuilder(key=" + this.key + ", cacheExpiry=" + this.cacheExpiry + ", cacheMaxSize=" + this.cacheMaxSize + ", clockSkew=" + this.clockSkew + ")";
        }
    }
}

