/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.jwt.JwtAuthDynamicFeature;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.JwtUserValueFactoryProvider;
import io.dropwizard.auth.jwt.config.JwtAuthBundleConfiguration;
import io.dropwizard.auth.jwt.core.JwtUser;
import io.dropwizard.auth.jwt.resources.TokenResource;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.AesKey;

public abstract class JwtAuthBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private Key key;
    private JwtConsumer jwtConsumer;
    private JsonWebEncryption jwe;

    public void run(T configuration, Environment environment) throws Exception {
        JwtAuthBundleConfiguration jwtAuthBundleConfiguration = this.getJwtAuthBundleConfiguration(configuration);
        this.key = new AesKey(jwtAuthBundleConfiguration.getKey().getBytes(StandardCharsets.UTF_8));
        this.jwtConsumer = new JwtConsumerBuilder().setRequireJwtId().setAllowedClockSkewInSeconds(jwtAuthBundleConfiguration.getClockSkew()).setDisableRequireSignature().setSkipSignatureVerification().setRequireSubject().setSkipDefaultAudienceValidation().setDecryptionKey(this.key).build();
        this.jwe = new JsonWebEncryption();
        this.jwe.setAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"A128KW"}));
        this.jwe.setContentEncryptionAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"A256CBC-HS512"}));
        this.jwe.setAlgorithmHeaderValue("A128KW");
        this.jwe.setEncryptionMethodHeaderParameter("A256CBC-HS512");
        this.jwe.setKey(this.key);
        environment.jersey().register((Object)JwtAuthDynamicFeature.builder().authorizer(this.authorizer()).jwtConsumer(this.jwtConsumer).authHeader(jwtAuthBundleConfiguration.getAuthHeader()).cacheExpiry(jwtAuthBundleConfiguration.getCacheExpiry()).cacheSize(jwtAuthBundleConfiguration.getCacheMaxSize()).build());
        environment.jersey().register(new JwtUserValueFactoryProvider.Binder<JwtUser>(JwtUser.class));
        environment.jersey().register((Object)TokenResource.builder().jwe(this.jwe).build());
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    protected JwtAuthBundleConfiguration getJwtAuthBundleConfiguration(T configuration) {
        return new JwtAuthBundleConfiguration();
    }

    protected JwtAuthorizer authorizer() {
        return null;
    }

    public JwtConsumer getJwtConsumer() {
        return this.jwtConsumer;
    }

    public JsonWebEncryption getJwe() {
        return this.jwe;
    }
}

