/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.core;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jose4j.jwt.JwtClaims;

public class JwtUser
implements Principal {
    private final JwtClaims claims;

    @Override
    public String getName() {
        return this.claims.getSubject();
    }

    @Override
    public boolean implies(Subject subject) {
        return Principal.super.implies(subject);
    }

    JwtUser(JwtClaims claims) {
        this.claims = claims;
    }

    public static JwtUserBuilder builder() {
        return new JwtUserBuilder();
    }

    public JwtClaims getClaims() {
        return this.claims;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtUser)) {
            return false;
        }
        JwtUser other = (JwtUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JwtClaims this$claims = this.getClaims();
        JwtClaims other$claims = other.getClaims();
        return !(this$claims == null ? other$claims != null : !this$claims.equals(other$claims));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JwtClaims $claims = this.getClaims();
        result = result * 59 + ($claims == null ? 43 : $claims.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "JwtUser(claims=" + this.getClaims() + ")";
    }

    public static class JwtUserBuilder {
        private JwtClaims claims;

        JwtUserBuilder() {
        }

        public JwtUserBuilder claims(JwtClaims claims) {
            this.claims = claims;
            return this;
        }

        public JwtUser build() {
            return new JwtUser(this.claims);
        }

        public String toString() {
            return "JwtUser.JwtUserBuilder(claims=" + this.claims + ")";
        }
    }
}

