/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.annotation.JwtAuthParam;
import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import io.dropwizard.auth.jwt.core.JwtUser;
import io.dropwizard.auth.jwt.util.TokenUtils;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthDynamicFeature
implements DynamicFeature {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthDynamicFeature.class);
    public static final String AUTHORIZED_FOR_SUBJECT = "X-AUTHORIZED-FOR-SUBJECT";
    public static final String AUTHORIZED_FOR_MASK = "X-AUTHORIZED-FOR-%s";
    private final JwtAuthorizer authorizer;
    private final JwtConsumer jwtConsumer;
    private final LoadingCache<String, JwtUser> tokenCache;
    private final String tokenHeader;

    public JwtAuthDynamicFeature(JwtConsumer jwtConsumer, int cacheExpiry, int cacheSize, JwtAuthorizer authorizer, String authHeader) {
        this.tokenHeader = authHeader;
        this.jwtConsumer = jwtConsumer;
        this.authorizer = authorizer;
        this.tokenCache = Caffeine.newBuilder().expireAfterWrite((long)cacheExpiry, TimeUnit.SECONDS).maximumSize((long)cacheSize).build(this::getUser);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Annotation[][] parameterAnnotations;
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        for (Annotation[] parameterAnnotation : parameterAnnotations = am.getParameterAnnotations()) {
            JwtAuthRequired jwt = this.containsJWTAnnotation(parameterAnnotation);
            if (!Objects.nonNull(jwt)) continue;
            context.register((Object)this.getAuthFilter(jwt));
            return;
        }
    }

    private JwtAuthRequired containsJWTAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof JwtAuthRequired)) continue;
            JwtAuthRequired requiredAnnotation = (JwtAuthRequired)annotation;
            return requiredAnnotation;
        }
        return null;
    }

    private JwtUser getUser(String token) {
        try {
            return TokenUtils.verify(this.jwtConsumer, token);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private ContainerRequestFilter getAuthFilter(JwtAuthRequired authRequired) {
        return containerRequestContext -> {
            JwtUser user;
            block11: {
                String authHeader = containerRequestContext.getHeaderString(this.tokenHeader);
                if (authHeader == null) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                String token = authHeader.trim().startsWith("Bearer") ? authHeader.replace("Bearer", "").trim() : authHeader.trim();
                try {
                    user = (JwtUser)this.tokenCache.get((Object)token);
                    boolean authorize = false;
                    authorize = Arrays.asList(authRequired.value()).contains("*");
                    if (!authorize) {
                        for (String audience : user.getClaims().getAudience()) {
                            if (!Arrays.asList(authRequired.value()).contains(audience)) continue;
                            authorize = true;
                            break;
                        }
                    }
                    if (Objects.nonNull(authRequired.authParams())) {
                        for (JwtAuthParam param : authRequired.authParams()) {
                            if (!user.getClaims().hasClaim(param.name()) || !user.getClaims().isClaimValueOfType(param.name(), ArrayList.class) || !Collections.disjoint(Arrays.asList(param.value()), (Collection)user.getClaims().getClaimValue(param.name(), ArrayList.class))) continue;
                            authorize = false;
                            break;
                        }
                    }
                    if (authorize) {
                        if (Objects.nonNull(this.authorizer) && !this.authorizer.authorize(user.getClaims(), containerRequestContext)) {
                            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                        }
                        break block11;
                    }
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                catch (Exception e) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
            }
            containerRequestContext.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return user;
                }

                public boolean isUserInRole(String s) {
                    try {
                        return user.getClaims().getAudience().contains(s);
                    }
                    catch (MalformedClaimException e) {
                        return false;
                    }
                }

                public boolean isSecure() {
                    return true;
                }

                public String getAuthenticationScheme() {
                    return "JWT";
                }
            });
            containerRequestContext.setProperty("user", (Object)user);
            try {
                this.stampHeaders(containerRequestContext, user.getClaims());
            }
            catch (MalformedClaimException e) {
                log.error("Cannot stamp headers for user: {}", (Object)user.getName(), (Object)e);
            }
        };
    }

    public void stampHeaders(ContainerRequestContext requestContext, JwtClaims jwtClaims) throws MalformedClaimException {
        requestContext.getHeaders().putSingle((Object)AUTHORIZED_FOR_SUBJECT, (Object)jwtClaims.getSubject());
        jwtClaims.flattenClaims().forEach((s, objects) -> requestContext.getHeaders().putSingle((Object)String.format(AUTHORIZED_FOR_MASK, s), (Object)String.valueOf(objects)));
    }

    @Generated
    public static JwtAuthDynamicFeatureBuilder builder() {
        return new JwtAuthDynamicFeatureBuilder();
    }

    @Generated
    public static class JwtAuthDynamicFeatureBuilder {
        @Generated
        private JwtConsumer jwtConsumer;
        @Generated
        private int cacheExpiry;
        @Generated
        private int cacheSize;
        @Generated
        private JwtAuthorizer authorizer;
        @Generated
        private String authHeader;

        @Generated
        JwtAuthDynamicFeatureBuilder() {
        }

        @Generated
        public JwtAuthDynamicFeatureBuilder jwtConsumer(JwtConsumer jwtConsumer) {
            this.jwtConsumer = jwtConsumer;
            return this;
        }

        @Generated
        public JwtAuthDynamicFeatureBuilder cacheExpiry(int cacheExpiry) {
            this.cacheExpiry = cacheExpiry;
            return this;
        }

        @Generated
        public JwtAuthDynamicFeatureBuilder cacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        @Generated
        public JwtAuthDynamicFeatureBuilder authorizer(JwtAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        @Generated
        public JwtAuthDynamicFeatureBuilder authHeader(String authHeader) {
            this.authHeader = authHeader;
            return this;
        }

        @Generated
        public JwtAuthDynamicFeature build() {
            return new JwtAuthDynamicFeature(this.jwtConsumer, this.cacheExpiry, this.cacheSize, this.authorizer, this.authHeader);
        }

        @Generated
        public String toString() {
            return "JwtAuthDynamicFeature.JwtAuthDynamicFeatureBuilder(jwtConsumer=" + this.jwtConsumer + ", cacheExpiry=" + this.cacheExpiry + ", cacheSize=" + this.cacheSize + ", authorizer=" + this.authorizer + ", authHeader=" + this.authHeader + ")";
        }
    }
}

