/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.resources;

import com.codahale.metrics.annotation.Metered;
import io.dropwizard.auth.jwt.core.TokenRequest;
import io.dropwizard.auth.jwt.core.TokenResponse;
import io.dropwizard.auth.jwt.util.TokenUtils;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jwt/v1")
@Singleton
public class TokenResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenResource.class);
    private final JsonWebEncryption jwe;

    public TokenResource(JsonWebEncryption jwe) {
        this.jwe = jwe;
    }

    @Path(value="/token/generate")
    @POST
    @Metered
    public Response generate(TokenRequest tokenRequest) {
        try {
            String token = TokenUtils.generate(this.jwe, tokenRequest);
            return Response.ok((Object)TokenResponse.builder().token(token).build()).build();
        }
        catch (JoseException je) {
            throw new WebApplicationException(ExceptionUtils.getRootCauseMessage((Throwable)je), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Generated
    public static TokenResourceBuilder builder() {
        return new TokenResourceBuilder();
    }

    @Generated
    public static class TokenResourceBuilder {
        @Generated
        private JsonWebEncryption jwe;

        @Generated
        TokenResourceBuilder() {
        }

        @Generated
        public TokenResourceBuilder jwe(JsonWebEncryption jwe) {
            this.jwe = jwe;
            return this;
        }

        @Generated
        public TokenResource build() {
            return new TokenResource(this.jwe);
        }

        @Generated
        public String toString() {
            return "TokenResource.TokenResourceBuilder(jwe=" + this.jwe + ")";
        }
    }
}

