/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthFilter;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerAuthConfigFilter
extends AuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthConfigFilter.class);
    private final SecretKeySpec secretKeySpec;
    private final GCMParameterSpec ivParameterSpec;

    public PrimerAuthConfigFilter(PrimerBundleConfiguration configuration, ObjectMapper objectMapper, SecretKeySpec secretKeySpec, GCMParameterSpec ivParameterSpec) {
        super(AuthType.CONFIG, configuration, objectMapper);
        this.secretKeySpec = secretKeySpec;
        this.ivParameterSpec = ivParameterSpec;
    }

    @Metered(name="primer")
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.isEnabled() || this.isWhitelisted(requestContext)) {
            return;
        }
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)this.configuration.getAbsentTokenStatus()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build())).build());
        } else {
            try {
                String decryptedToken = this.tokenDecrypt(token.get());
                JsonWebToken webToken = this.authorize(requestContext, decryptedToken, this.authType);
                this.stampHeaders(requestContext, webToken);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), requestContext, token.get());
                } else {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
                this.handleException(e, requestContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configuration.isEnabled() && this.configuration.getAuthTypesEnabled().getOrDefault((Object)AuthType.CONFIG, false) != false;
    }

    private boolean isWhitelisted(ContainerRequestContext requestContext) {
        return PrimerAuthorizationRegistry.isWhilisted(requestContext.getUriInfo().getPath());
    }

    public String tokenDecrypt(String token) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
            cipher.init(2, (Key)this.secretKeySpec, this.ivParameterSpec);
            return new String(cipher.doFinal(Base64.getDecoder().decode(token)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return token;
        }
    }

    public static PrimerAuthConfigFilterBuilder builder() {
        return new PrimerAuthConfigFilterBuilder();
    }

    public static class PrimerAuthConfigFilterBuilder {
        private PrimerBundleConfiguration configuration;
        private ObjectMapper objectMapper;
        private SecretKeySpec secretKeySpec;
        private GCMParameterSpec ivParameterSpec;

        PrimerAuthConfigFilterBuilder() {
        }

        public PrimerAuthConfigFilterBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthConfigFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerAuthConfigFilterBuilder secretKeySpec(SecretKeySpec secretKeySpec) {
            this.secretKeySpec = secretKeySpec;
            return this;
        }

        public PrimerAuthConfigFilterBuilder ivParameterSpec(GCMParameterSpec ivParameterSpec) {
            this.ivParameterSpec = ivParameterSpec;
            return this;
        }

        public PrimerAuthConfigFilter build() {
            return new PrimerAuthConfigFilter(this.configuration, this.objectMapper, this.secretKeySpec, this.ivParameterSpec);
        }

        public String toString() {
            return "PrimerAuthConfigFilter.PrimerAuthConfigFilterBuilder(configuration=" + this.configuration + ", objectMapper=" + this.objectMapper + ", secretKeySpec=" + this.secretKeySpec + ", ivParameterSpec=" + this.ivParameterSpec + ")";
        }
    }
}

