/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.github.toastshaman.dropwizard.auth.jwt.validator.ExpiryValidator;
import com.google.common.base.Strings;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.core.ServiceUser;
import io.dropwizard.primer.core.VerifyResponse;
import io.dropwizard.primer.core.VerifyStaticResponse;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerAuthorization;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerAuthorizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthorizationRegistry.class);
    private static Map<String, PrimerAuthorization> authList;
    private static List<String> whiteList;
    private static List<String> urlPatterns;
    private static LoadingCache<String, Optional<Boolean>> blacklistCache;
    private static LoadingCache<TokenKey, JsonWebToken> lruCache;
    private static JsonWebTokenParser parser;
    private static HmacSHA512Verifier verifier;
    private static ExpiryValidator expiryValidator;

    public static void init(PrimerAuthorizationMatrix matrix, Set<String> whiteListUrls, PrimerBundleConfiguration configuration, JsonWebTokenParser tokenParser, HmacSHA512Verifier tokenVerifier) {
        parser = tokenParser;
        verifier = tokenVerifier;
        Pattern tokenMatch = Pattern.compile("\\{(([^/])+\\})");
        HashMap<String, PrimerAuthorization> authList = new HashMap<String, PrimerAuthorization>();
        ArrayList<String> urlPatterns = new ArrayList<String>();
        if (matrix != null) {
            if (matrix.getAuthorizations() != null) {
                matrix.getAuthorizations().forEach(auth -> {
                    String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                    urlPatterns.add(pattern);
                    authList.put(pattern, (PrimerAuthorization)auth);
                });
            }
            if (matrix.getStaticAuthorizations() != null) {
                matrix.getStaticAuthorizations().forEach(auth -> {
                    String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                    urlPatterns.add(pattern);
                    authList.put(pattern, (PrimerAuthorization)auth);
                });
            }
            if (matrix.getAutoAuthorizations() != null) {
                matrix.getAutoAuthorizations().forEach(auth -> {
                    String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                    urlPatterns.add(pattern);
                    authList.put(pattern, (PrimerAuthorization)auth);
                });
            }
            urlPatterns.sort((o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
            urlPatterns.sort(Comparator.reverseOrder());
        }
        PrimerAuthorizationRegistry.authList = authList;
        whiteList = PrimerAuthorizationRegistry.primerWhitelistedUrls(whiteListUrls, tokenMatch);
        PrimerAuthorizationRegistry.urlPatterns = urlPatterns;
        expiryValidator = new ExpiryValidator(new Duration((long)configuration.getClockSkew()));
        blacklistCache = Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()).build(key -> Optional.of(false));
        lruCache = Caffeine.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()).build(PrimerAuthorizationRegistry::verifyToken);
    }

    private static List<String> primerWhitelistedUrls(Set<String> whiteListUrls, Pattern tokenMatch) {
        ArrayList<String> whiteList = new ArrayList<String>();
        whiteListUrls.forEach(url -> whiteList.add(PrimerAuthorizationRegistry.generatePathExpression(url)));
        whiteList.sort((o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
        whiteList.sort(Comparator.reverseOrder());
        return whiteList;
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static JsonWebToken authorize(String path, String method, String token, AuthType authType) {
        return (JsonWebToken)lruCache.get((Object)TokenKey.builder().method(method).path(path).token(token).authType(authType).build());
    }

    public static boolean isWhilisted(String path) {
        return whiteList.stream().anyMatch(path::matches);
    }

    private static boolean isAuthorized(String id, String method, String role) {
        return authList.get(id).getRoles().contains(role) && authList.get(id).getMethods().contains(method);
    }

    private static JsonWebToken verify(JsonWebToken webToken, String token, String type) throws PrimerException {
        switch (type) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verifyDynamic(webToken, token);
            }
            case "static": {
                return PrimerAuthorizationRegistry.verifyStatic(webToken, token);
            }
        }
        log.debug("invalid_token_type type:{} token:{}", (Object)type, (Object)token);
        throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
    }

    private static JsonWebToken verifyDynamic(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyResponse verifyResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, ServiceUser.builder().id((String)webToken.claim().getParameter("user_id")).name((String)webToken.claim().getParameter("name")).role((String)webToken.claim().getParameter("role")).build());
        boolean bl = result = !Strings.isNullOrEmpty((String)verifyResponse.getToken()) && !Strings.isNullOrEmpty((String)verifyResponse.getUserId());
        if (!result) {
            log.debug("dynamic_token_validation_failed token:{} verify_response:{}", (Object)token, (Object)verifyResponse);
            PrimerAuthorizationRegistry.blacklist(token);
            throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
        }
        return webToken;
    }

    private static JsonWebToken verifyStatic(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyStaticResponse verifyStaticResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, (String)webToken.claim().getParameter("role"));
        boolean bl = result = !Strings.isNullOrEmpty((String)verifyStaticResponse.getToken()) && !Strings.isNullOrEmpty((String)verifyStaticResponse.getId());
        if (!result) {
            log.debug("dynamic_token_validation_failed token:{} verify_response:{}", (Object)token, (Object)verifyStaticResponse);
            PrimerAuthorizationRegistry.blacklist(token);
            throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
        }
        return webToken;
    }

    private static JsonWebToken verifyConfigAuthToken(TokenKey tokenKey) throws PrimerException {
        JsonWebToken webToken = parser.parse(tokenKey.getToken());
        verifier.verifySignature(webToken);
        expiryValidator.validate(webToken);
        String role = (String)webToken.claim().getParameter("role");
        Optional<String> index = urlPatterns.stream().filter(tokenKey.getPath()::matches).findFirst();
        if (!index.isPresent()) {
            log.debug("No index found for {}", (Object)tokenKey);
            throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
        }
        if (!PrimerAuthorizationRegistry.isAuthorized(index.get(), tokenKey.getMethod(), role)) {
            log.debug("Role, method combo check failed for Method={} Role={} Index={}", new Object[]{index.get(), role, tokenKey.getMethod()});
            throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
        }
        switch (authList.get(index.get()).getType()) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), "dynamic");
            }
            case "static": {
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), "static");
            }
            case "auto": {
                String type = (String)webToken.claim().getParameter("type");
                return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), type);
            }
        }
        log.debug("invalid_token_type for index:{} token:{}", (Object)authList.get(index.get()).getType(), (Object)tokenKey);
        throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
    }

    private static JsonWebToken verifyAnnotationAuthToken(TokenKey tokenKey) throws PrimerException {
        JsonWebToken webToken = parser.parse(tokenKey.getToken());
        verifier.verifySignature(webToken);
        expiryValidator.validate(webToken);
        String type = (String)webToken.claim().getParameter("type");
        return PrimerAuthorizationRegistry.verify(webToken, tokenKey.getToken(), type);
    }

    private static JsonWebToken verifyToken(TokenKey tokenKey) throws PrimerException {
        switch (tokenKey.getAuthType()) {
            case CONFIG: {
                return PrimerAuthorizationRegistry.verifyConfigAuthToken(tokenKey);
            }
            case ANNOTATION: {
                return PrimerAuthorizationRegistry.verifyAnnotationAuthToken(tokenKey);
            }
        }
        throw PrimerException.builder().errorCode("PR004").message("Unauthorized").status(401).build();
    }

    static void blacklist(String token) {
        blacklistCache.put((Object)token, Optional.of(true));
    }

    private static class TokenKey {
        private String token;
        private String path;
        private String method;
        private AuthType authType;

        public static TokenKeyBuilder builder() {
            return new TokenKeyBuilder();
        }

        public String getToken() {
            return this.token;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }

        public AuthType getAuthType() {
            return this.authType;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setAuthType(AuthType authType) {
            this.authType = authType;
        }

        public TokenKey(String token, String path, String method, AuthType authType) {
            this.token = token;
            this.path = path;
            this.method = method;
            this.authType = authType;
        }

        public TokenKey() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenKey)) {
                return false;
            }
            TokenKey other = (TokenKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        public String toString() {
            return "PrimerAuthorizationRegistry.TokenKey(token=" + this.getToken() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", authType=" + (Object)((Object)this.getAuthType()) + ")";
        }

        public static class TokenKeyBuilder {
            private String token;
            private String path;
            private String method;
            private AuthType authType;

            TokenKeyBuilder() {
            }

            public TokenKeyBuilder token(String token) {
                this.token = token;
                return this;
            }

            public TokenKeyBuilder path(String path) {
                this.path = path;
                return this;
            }

            public TokenKeyBuilder method(String method) {
                this.method = method;
                return this;
            }

            public TokenKeyBuilder authType(AuthType authType) {
                this.authType = authType;
                return this;
            }

            public TokenKey build() {
                return new TokenKey(this.token, this.path, this.method, this.authType);
            }

            public String toString() {
                return "PrimerAuthorizationRegistry.TokenKey.TokenKeyBuilder(token=" + this.token + ", path=" + this.path + ", method=" + this.method + ", authType=" + (Object)((Object)this.authType) + ")";
            }
        }
    }
}

