/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAddressUtil {
    private static final Logger log = LoggerFactory.getLogger(IPAddressUtil.class);
    private static final String X_REAL_IP = "x-real-ip";
    private static final String X_FORWARDED_FOR = "x-forwarded-for";

    public static String getIP(HttpServletRequest httpServletRequest) {
        String[] ips;
        if (StringUtils.isNotBlank((CharSequence)httpServletRequest.getHeader(X_REAL_IP))) {
            return httpServletRequest.getHeader(X_REAL_IP);
        }
        if (StringUtils.isNotBlank((CharSequence)httpServletRequest.getHeader(X_FORWARDED_FOR)) && (ips = httpServletRequest.getHeader(X_FORWARDED_FOR).split(",")).length > 0) {
            return ips[0];
        }
        return httpServletRequest.getRemoteAddr();
    }
}

