/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.token;

import com.google.common.base.Strings;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(PrimerTokenProvider.class);
    protected String primerCookie = "P_SESSIONID";

    protected Optional<String> fetchTokenFromCookies(ContainerRequestContext requestContext, PrimerConfigurationHolder configHolder) {
        Cookie cookie;
        if (!configHolder.getConfig().isCookiesEnabled()) {
            return Optional.empty();
        }
        if (Objects.nonNull(this.primerCookie) && Objects.nonNull(cookie = (Cookie)requestContext.getCookies().get(this.primerCookie))) {
            String cookieValue = cookie.getValue();
            return Optional.ofNullable(cookieValue);
        }
        return Optional.empty();
    }

    protected Optional<String> fetchTokenFromHeader(ContainerRequestContext requestContext, PrimerConfigurationHolder configHolder) {
        String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        log.debug("Authorization Header: {}", (Object)header);
        if (header != null) {
            String rawToken = header.replaceAll(configHolder.getConfig().getPrefix(), "").trim();
            if (Strings.isNullOrEmpty((String)rawToken)) {
                return Optional.empty();
            }
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    public Optional<String> getToken(ContainerRequestContext requestContext, PrimerConfigurationHolder configHolder) {
        Optional<String> header = this.fetchTokenFromHeader(requestContext, configHolder);
        if (!header.isPresent()) {
            header = this.fetchTokenFromCookies(requestContext, configHolder);
        }
        return header;
    }

    public static PrimerTokenProviderBuilder builder() {
        return new PrimerTokenProviderBuilder();
    }

    public PrimerTokenProvider() {
    }

    public PrimerTokenProvider(String primerCookie) {
        this.primerCookie = primerCookie;
    }

    public static class PrimerTokenProviderBuilder {
        private String primerCookie;

        PrimerTokenProviderBuilder() {
        }

        public PrimerTokenProviderBuilder primerCookie(String primerCookie) {
            this.primerCookie = primerCookie;
            return this;
        }

        public PrimerTokenProvider build() {
            return new PrimerTokenProvider(this.primerCookie);
        }

        public String toString() {
            return "PrimerTokenProvider.PrimerTokenProviderBuilder(primerCookie=" + this.primerCookie + ")";
        }
    }
}

