/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.orchestration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.exception.PrimerException;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import lombok.NonNull;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;

public class KeyOrchestrator {
    private final LoadingCache<String, RsaJsonWebKey> jwkPublicKeyLruCache;
    private final ObjectMapper mapper;

    public KeyOrchestrator(int jwkPublicKeyCacheMaxSize, ObjectMapper objectMapper) {
        this.jwkPublicKeyLruCache = Caffeine.newBuilder().maximumSize((long)jwkPublicKeyCacheMaxSize).build(this::getPublicJwkViaNetworkCall);
        this.mapper = objectMapper;
    }

    private RsaJsonWebKey getPublicJwkViaNetworkCall(@NonNull String keyId) throws PrimerException, JoseException {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        JsonNode jwkJson = PrimerBundle.getPrimerClient().getPublicKey(keyId);
        Map jwkMap = (Map)this.mapper.convertValue((Object)jwkJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return new RsaJsonWebKey(jwkMap);
    }

    private RsaJsonWebKey getPublicJwk(@NonNull String keyId) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        return (RsaJsonWebKey)this.jwkPublicKeyLruCache.get((Object)keyId);
    }

    public HmacKey getHmacPublicKey(String hmacPrivateKey) {
        return new HmacKey(hmacPrivateKey.getBytes(StandardCharsets.UTF_8));
    }

    public RSAPublicKey getRsaPublicKey(String rsaKeyId) {
        RsaJsonWebKey rsaJsonWebKey = this.getPublicJwk(rsaKeyId);
        return rsaJsonWebKey.getRsaPublicKey();
    }
}

