/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.target;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import feign.Target;
import feign.ranger.RangerTarget;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.model.PrimerEndpoint;
import io.dropwizard.primer.model.PrimerRangerEndpoint;
import io.dropwizard.primer.model.PrimerSimpleEndpoint;
import java.util.function.Supplier;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerTarget {
    private static final Logger log = LoggerFactory.getLogger(PrimerTarget.class);
    private final Target<PrimerClient> target;

    public PrimerTarget(PrimerEndpoint primerEndpoint, ObjectMapper objectMapper, Supplier<CuratorFramework> curatorFrameworkSupplier) throws Exception {
        if (primerEndpoint instanceof PrimerSimpleEndpoint) {
            this.target = this.makeTarget((PrimerSimpleEndpoint)primerEndpoint);
        } else if (primerEndpoint instanceof PrimerRangerEndpoint) {
            this.target = this.makeTarget((PrimerRangerEndpoint)primerEndpoint, objectMapper, curatorFrameworkSupplier.get());
        } else {
            throw new IllegalArgumentException("unknown primer target type specified");
        }
    }

    private Target<PrimerClient> makeTarget(PrimerSimpleEndpoint primerSimpleEndpoint) {
        String rootPathPrefix = "";
        if (!Strings.isNullOrEmpty((String)primerSimpleEndpoint.getRootPathPrefix())) {
            rootPathPrefix = "/" + primerSimpleEndpoint.getRootPathPrefix();
        }
        String httpScheme = "http";
        if (primerSimpleEndpoint.isSecure()) {
            httpScheme = "https";
        }
        String url = String.format("%s://%s:%d%s", httpScheme, primerSimpleEndpoint.getHost(), primerSimpleEndpoint.getPort(), rootPathPrefix);
        return new Target.HardCodedTarget(PrimerClient.class, url);
    }

    private Target<PrimerClient> makeTarget(PrimerRangerEndpoint primerRangerEndpoint, ObjectMapper objectMapper, CuratorFramework curatorFramework) throws Exception {
        return RangerTarget.builder().type(PrimerClient.class).environment(primerRangerEndpoint.getEnvironment()).namespace(primerRangerEndpoint.getNamespace()).service(primerRangerEndpoint.getService()).curator(curatorFramework).secured(primerRangerEndpoint.isSecure()).objectMapper(objectMapper).rootPathPrefix(primerRangerEndpoint.getRootPathPrefix()).build();
    }

    public static PrimerTargetBuilder builder() {
        return new PrimerTargetBuilder();
    }

    public Target<PrimerClient> getTarget() {
        return this.target;
    }

    public static class PrimerTargetBuilder {
        private PrimerEndpoint primerEndpoint;
        private ObjectMapper objectMapper;
        private Supplier<CuratorFramework> curatorFrameworkSupplier;

        PrimerTargetBuilder() {
        }

        public PrimerTargetBuilder primerEndpoint(PrimerEndpoint primerEndpoint) {
            this.primerEndpoint = primerEndpoint;
            return this;
        }

        public PrimerTargetBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerTargetBuilder curatorFrameworkSupplier(Supplier<CuratorFramework> curatorFrameworkSupplier) {
            this.curatorFrameworkSupplier = curatorFrameworkSupplier;
            return this;
        }

        public PrimerTarget build() throws Exception {
            return new PrimerTarget(this.primerEndpoint, this.objectMapper, this.curatorFrameworkSupplier);
        }

        public String toString() {
            return "PrimerTarget.PrimerTargetBuilder(primerEndpoint=" + this.primerEndpoint + ", objectMapper=" + this.objectMapper + ", curatorFrameworkSupplier=" + this.curatorFrameworkSupplier + ")";
        }
    }
}

