/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.ranger;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class RangerBackendService
implements ServiceDiscoveryBackend,
ConnectionStateListener {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private String registrationId;
    private String namespace;
    private String service;
    private String basePath;
    private int connectionTimeoutMs;
    private CuratorFramework client;
    private Vertx vertx;
    private ConnectionState connectionState = ConnectionState.LOST;

    public void init(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.registrationId = config.getString("host") + ":" + config.getInteger("port");
        this.namespace = config.getString("namespace");
        this.service = config.getString("service");
        this.basePath = this.namespace.startsWith("/") ? this.namespace : "/" + this.namespace;
        this.basePath = this.basePath + "/" + this.service;
        this.connectionTimeoutMs = config.getInteger("connectionTimeoutMs", Integer.valueOf(1000));
        this.client = CuratorFrameworkFactory.builder().connectString(config.getString("zkConnectionString")).connectionTimeoutMs(config.getInteger("connectionTimeoutMs", Integer.valueOf(1000)).intValue()).retryPolicy((RetryPolicy)new RetryForever(config.getInteger("baseSleepTimeBetweenRetries", Integer.valueOf(1000)).intValue())).build();
        this.client.getConnectionStateListenable().addListener((Object)this);
        this.client.start();
    }

    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        if (record.getRegistration() != null) {
            resultHandler.handle((Object)Future.failedFuture((String)"The record has already been registered"));
            return;
        }
        record.setRegistration(this.registrationId);
        JsonObject nodeData = record.toJson();
        nodeData.put("lastUpdatedTimeStamp", Long.valueOf(System.currentTimeMillis()));
        String content = record.toJson().encode();
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).inBackground((curatorFramework, curatorEvent) -> this.callback(context, record, resultHandler, curatorEvent))).withUnhandledErrorListener((s, throwable) -> resultHandler.handle((Object)Future.failedFuture((Throwable)throwable))).forPath(this.getPath(record.getRegistration()), content.getBytes(CHARSET));
                }
                catch (Exception e) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
    }

    public void remove(Record record, Handler<AsyncResult<Record>> handler) {
        this.remove(record.getRegistration(), handler);
    }

    public void remove(String registration, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(registration, "No registration id in the record");
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                this.getRecordByRegistration(context, registration, (Handler<Record>)((Handler)record -> {
                    if (record == null) {
                        resultHandler.handle((Object)Future.failedFuture((String)("Unknown registration " + registration)));
                    } else {
                        try {
                            DeleteBuilder delete = this.client.delete();
                            delete.guaranteed();
                            ((ErrorListenerPathable)delete.deletingChildrenIfNeeded().inBackground((curatorFramework, curatorEvent) -> this.callback(context, (Record)record, resultHandler, curatorEvent))).withUnhandledErrorListener((s, throwable) -> resultHandler.handle((Object)Future.failedFuture((Throwable)throwable))).forPath(this.getPath(registration));
                        }
                        catch (Exception e) {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                        }
                    }
                }));
            }
        }));
    }

    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    JsonObject nodeData = record.toJson();
                    nodeData.put("lastUpdatedTimeStamp", Long.valueOf(System.currentTimeMillis()));
                    ((ErrorListenerPathAndBytesable)this.client.setData().inBackground((framework, event) -> this.runOnContextIfPossible(context, () -> {
                        if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                            resultHandler.handle((Object)Future.succeededFuture());
                        } else {
                            KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
                            resultHandler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
                        }
                    }))).withUnhandledErrorListener((message, e) -> resultHandler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.getPath(record.getRegistration()), nodeData.encode().getBytes(CHARSET));
                }
                catch (Exception e2) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getChildren().inBackground((fmk, event) -> {
                        List children = event.getChildren();
                        ArrayList<Future> futures = new ArrayList<Future>();
                        for (String child : children) {
                            Promise promise = Promise.promise();
                            this.getRecord(child, (Handler<AsyncResult<Record>>)promise);
                            futures.add(promise.future());
                        }
                        CompositeFuture.all(futures).onComplete(ar -> this.runOnContextIfPossible(context, () -> {
                            if (ar.failed()) {
                                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                            } else {
                                ArrayList<Record> records = new ArrayList<Record>();
                                for (Future future : futures) {
                                    records.add((Record)future.result());
                                }
                                resultHandler.handle((Object)Future.succeededFuture(records));
                            }
                        }));
                    })).withUnhandledErrorListener((message, e) -> resultHandler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.basePath);
                }
                catch (Exception e2) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public void getRecord(String registration, Handler<AsyncResult<Record>> handler) {
        Objects.requireNonNull(registration);
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getData().inBackground((fmk, curatorEvent) -> this.runOnContextIfPossible(context, () -> {
                        if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                            JsonObject json = new JsonObject(new String(curatorEvent.getData(), CHARSET));
                            handler.handle((Object)Future.succeededFuture((Object)new Record(json)));
                        } else if (curatorEvent.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                            handler.handle((Object)Future.succeededFuture(null));
                        } else {
                            KeeperException.Code code = KeeperException.Code.get((int)curatorEvent.getResultCode());
                            handler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
                        }
                    }))).withUnhandledErrorListener((message, e) -> handler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.getPath(registration));
                }
                catch (Exception e2) {
                    handler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.connectionState = newState;
    }

    private synchronized void ensureConnected(Handler<AsyncResult<Void>> handler) {
        switch (this.connectionState) {
            case CONNECTED: 
            case RECONNECTED: {
                handler.handle((Object)Future.succeededFuture());
                break;
            }
            case READ_ONLY: 
            case LOST: 
            case SUSPENDED: {
                this.vertx.executeBlocking(future -> {
                    try {
                        if (this.client.blockUntilConnected(this.connectionTimeoutMs, TimeUnit.MILLISECONDS)) {
                            future.complete();
                        } else {
                            future.fail((Throwable)new TimeoutException());
                        }
                    }
                    catch (Exception e) {
                        future.fail((Throwable)e);
                    }
                }, ar -> {
                    if (ar.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS)));
                    } else {
                        handler.handle((Object)Future.succeededFuture());
                    }
                });
            }
        }
    }

    private void runOnContextIfPossible(Context context, Runnable runnable) {
        if (context != null) {
            context.runOnContext(v -> runnable.run());
        } else {
            runnable.run();
        }
    }

    private void callback(Context context, Record record, Handler<AsyncResult<Record>> resultHandler, CuratorEvent curatorEvent) {
        this.runOnContextIfPossible(context, () -> {
            if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            } else {
                KeeperException.Code code = KeeperException.Code.get((int)curatorEvent.getResultCode());
                resultHandler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
            }
        });
    }

    private String getPath(String registration) {
        return this.basePath + "/" + registration;
    }

    private void getRecordByRegistration(Context context, String registration, Handler<Record> handler) {
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                handler.handle(null);
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getData().inBackground((curatorFramework, curatorEvent) -> this.runOnContextIfPossible(context, () -> {
                        if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                            JsonObject json = new JsonObject(new String(curatorEvent.getData(), CHARSET));
                            handler.handle((Object)new Record(json));
                        } else {
                            handler.handle(null);
                        }
                    }))).forPath(this.getPath(registration));
                }
                catch (Exception e) {
                    handler.handle(null);
                }
            }
        }));
    }
}

