/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.ranger;

import com.google.common.collect.ImmutableMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.Status;

public class RangerBackendServicePublisher {
    public static ServiceDiscovery publish(Vertx vertx, JsonObject config, Handler<AsyncResult<Record>> handler) {
        ImmutableMap shardInfo = ImmutableMap.builder().put((Object)"environment", (Object)config.getString("env")).build();
        JsonObject nodeData = new JsonObject();
        nodeData.put("host", config.getString("host"));
        nodeData.put("port", config.getInteger("port"));
        nodeData.put("healthcheckStatus", "healthy");
        nodeData.put("nodeData", (Object)shardInfo);
        Record record = new Record();
        record.setMetadata(nodeData);
        record.setStatus(Status.UP);
        record.setName(config.getString("service"));
        record.setType("ranger");
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions().setBackendConfiguration(config));
        discovery.publish(record, r -> {
            if (r.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)((Record)r.result())));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)r.cause()));
            }
        });
        return discovery;
    }
}

